/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.invocation;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.command.SimpleCommand;
import com.velocitypowered.proxy.command.VelocityCommands;
import com.velocitypowered.proxy.command.brigadier.StringArrayArgumentType;
import com.velocitypowered.proxy.command.invocation.AbstractCommandInvocation;
import com.velocitypowered.proxy.command.invocation.CommandInvocationFactory;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public final class SimpleCommandInvocation
extends AbstractCommandInvocation<String[]>
implements SimpleCommand.Invocation {
    public static final Factory FACTORY = new Factory();
    private final String alias;

    SimpleCommandInvocation(CommandSource source, String alias, String[] arguments) {
        super(source, arguments);
        this.alias = Preconditions.checkNotNull(alias, "alias");
    }

    @Override
    public String alias() {
        return this.alias;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SimpleCommandInvocation that = (SimpleCommandInvocation)o;
        return this.alias.equals(that.alias);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.alias.hashCode();
        return result;
    }

    public String toString() {
        return "SimpleCommandInvocation{source='" + String.valueOf(this.source()) + "', alias='" + this.alias + "', arguments='" + Arrays.toString((Object[])this.arguments()) + "'}";
    }

    private static class Factory
    implements CommandInvocationFactory<SimpleCommand.Invocation> {
        private Factory() {
        }

        @Override
        public SimpleCommand.Invocation create(CommandSource source, List<? extends ParsedCommandNode<?>> nodes, Map<String, ? extends ParsedArgument<?, ?>> arguments) {
            String alias = VelocityCommands.readAlias(nodes);
            String[] args = VelocityCommands.readArguments(arguments, String[].class, StringArrayArgumentType.EMPTY);
            return new SimpleCommandInvocation(source, alias, args);
        }
    }
}

