/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.channel.DefaultFileRegion;
import io.netty.channel.unix.Buffer;
import io.netty.channel.unix.FileDescriptor;
import io.netty.channel.unix.PeerCredentials;
import io.netty.channel.unix.Unix;
import io.netty.channel.uring.CompletionQueue;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.NativeStaticallyReferencedJniMethods;
import io.netty.channel.uring.RingBuffer;
import io.netty.channel.uring.SubmissionQueue;
import io.netty.util.internal.ClassInitializerUtil;
import io.netty.util.internal.NativeLibraryLoader;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.SystemPropertyUtil;
import io.netty.util.internal.ThrowableUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.nio.channels.Selector;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Locale;

final class Native {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Native.class);
    static final int SOCK_NONBLOCK;
    static final int SOCK_CLOEXEC;
    static final short AF_INET;
    static final short AF_INET6;
    static final short AF_UNIX;
    static final int SIZEOF_SOCKADDR_STORAGE;
    static final int SIZEOF_SOCKADDR_UN;
    static final int SOCKADDR_UN_OFFSETOF_SUN_FAMILY;
    static final int SOCKADDR_UN_OFFSETOF_SUN_PATH;
    static final int MAX_SUN_PATH_LEN;
    static final int SIZEOF_SOCKADDR_IN;
    static final int SIZEOF_SOCKADDR_IN6;
    static final int SOCKADDR_IN_OFFSETOF_SIN_FAMILY;
    static final int SOCKADDR_IN_OFFSETOF_SIN_PORT;
    static final int SOCKADDR_IN_OFFSETOF_SIN_ADDR;
    static final int IN_ADDRESS_OFFSETOF_S_ADDR;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_FAMILY;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_PORT;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_FLOWINFO;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_ADDR;
    static final int SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID;
    static final int IN6_ADDRESS_OFFSETOF_S6_ADDR;
    static final int SIZEOF_SIZE_T;
    static final int SIZEOF_IOVEC;
    static final int CMSG_SPACE;
    static final int CMSG_SPACE_FOR_FD;
    static final int CMSG_LEN;
    static final int CMSG_LEN_FOR_FD;
    static final int MSG_CONTROL_LEN_FOR_FD;
    static final int CMSG_OFFSETOF_CMSG_LEN;
    static final int CMSG_OFFSETOF_CMSG_LEVEL;
    static final int CMSG_OFFSETOF_CMSG_TYPE;
    static final int IO_URING_BUFFER_RING_TAIL;
    static final int IOVEC_OFFSETOF_IOV_BASE;
    static final int IOVEC_OFFSETOF_IOV_LEN;
    static final int SIZEOF_MSGHDR;
    static final int MSGHDR_OFFSETOF_MSG_NAME;
    static final int MSGHDR_OFFSETOF_MSG_NAMELEN;
    static final int MSGHDR_OFFSETOF_MSG_IOV;
    static final int MSGHDR_OFFSETOF_MSG_IOVLEN;
    static final int MSGHDR_OFFSETOF_MSG_CONTROL;
    static final int MSGHDR_OFFSETOF_MSG_CONTROLLEN;
    static final int MSGHDR_OFFSETOF_MSG_FLAGS;
    static final int POLLIN;
    static final int POLLOUT;
    static final int POLLRDHUP;
    static final int ERRNO_ECANCELED_NEGATIVE;
    static final int ERRNO_ETIME_NEGATIVE;
    static final int ERRNO_NOBUFS_NEGATIVE;
    static final int PAGE_SIZE;
    static final int MAX_SKB_FRAGS;
    static final int SIZEOF_IOURING_BUF;
    static final int IOURING_BUFFER_OFFSETOF_ADDR;
    static final int IOURING_BUFFER_OFFSETOF_LEN;
    static final int IOURING_BUFFER_OFFSETOF_BID;
    static final byte IORING_OP_NOP = 0;
    static final byte IORING_OP_READV = 1;
    static final byte IORING_OP_WRITEV = 2;
    static final byte IORING_OP_FSYNC = 3;
    static final byte IORING_OP_READ_FIXED = 4;
    static final byte IORING_OP_WRITE_FIXED = 5;
    static final byte IORING_OP_POLL_ADD = 6;
    static final byte IORING_OP_POLL_REMOVE = 7;
    static final byte IORING_OP_SYNC_FILE_RANGE = 8;
    static final byte IORING_OP_SENDMSG = 9;
    static final byte IORING_OP_RECVMSG = 10;
    static final byte IORING_OP_TIMEOUT = 11;
    static final byte IORING_OP_TIMEOUT_REMOVE = 12;
    static final byte IORING_OP_ACCEPT = 13;
    static final byte IORING_OP_ASYNC_CANCEL = 14;
    static final byte IORING_OP_LINK_TIMEOUT = 15;
    static final byte IORING_OP_CONNECT = 16;
    static final byte IORING_OP_FALLOCATE = 17;
    static final byte IORING_OP_OPENAT = 18;
    static final byte IORING_OP_CLOSE = 19;
    static final byte IORING_OP_FILES_UPDATE = 20;
    static final byte IORING_OP_STATX = 21;
    static final byte IORING_OP_READ = 22;
    static final byte IORING_OP_WRITE = 23;
    static final byte IORING_OP_FADVISE = 24;
    static final byte IORING_OP_MADVISE = 25;
    static final byte IORING_OP_SEND = 26;
    static final byte IORING_OP_RECV = 27;
    static final byte IORING_OP_OPENAT2 = 28;
    static final byte IORING_OP_EPOLL_CTL = 29;
    static final byte IORING_OP_SPLICE = 30;
    static final byte IORING_OP_PROVIDE_BUFFERS = 31;
    static final byte IORING_OP_REMOVE_BUFFERS = 32;
    static final byte IORING_OP_TEE = 33;
    static final byte IORING_OP_SHUTDOWN = 34;
    static final byte IORING_OP_RENAMEAT = 35;
    static final byte IORING_OP_UNLINKAT = 36;
    static final byte IORING_OP_MKDIRAT = 37;
    static final byte IORING_OP_SYMLINKAT = 38;
    static final byte IORING_OP_LINKAT = 39;
    static final byte IORING_OP_MSG_RING = 40;
    static final byte IORING_OP_FSETXATTR = 41;
    static final byte IORING_OP_SETXATTR = 42;
    static final byte IORING_OP_FGETXATTR = 43;
    static final byte IORING_OP_GETXATTR = 44;
    static final byte IORING_OP_SOCKET = 45;
    static final byte IORING_OP_URING_CMD = 46;
    static final byte IORING_OP_SEND_ZC = 47;
    static final byte IORING_OP_SENDMSG_ZC = 48;
    static final byte IORING_OP_READ_MULTISHOT = 49;
    static final byte IORING_OP_WAITID = 50;
    static final byte IORING_OP_FUTEX_WAIT = 51;
    static final byte IORING_OP_FUTEX_WAKE = 52;
    static final byte IORING_OP_FUTEX_WAITV = 53;
    static final byte IORING_OP_FIXED_FD_INSTALL = 54;
    static final byte IORING_OP_FTRUNCATE = 55;
    static final byte IORING_OP_BIND = 56;
    static final byte IORING_CQE_F_BUFFER = 1;
    static final byte IORING_CQE_F_MORE = 2;
    static final byte IORING_CQE_F_SOCK_NONEMPTY = 4;
    static final byte IORING_CQE_F_NOTIF = 8;
    static final byte IORING_CQE_F_BUF_MORE = 16;
    static final int IORING_SETUP_CQSIZE = 8;
    static final int IORING_SETUP_CLAMP = 16;
    static final int IORING_SETUP_R_DISABLED = 64;
    static final int IORING_SETUP_SUBMIT_ALL = 128;
    static final int IORING_SETUP_CQE32 = 2048;
    static final int IORING_SETUP_SINGLE_ISSUER = 4096;
    static final int IORING_SETUP_DEFER_TASKRUN = 8192;
    static final int IORING_SETUP_NO_SQARRAY = 65536;
    static final int IORING_CQE_BUFFER_SHIFT = 16;
    static final short IORING_POLL_ADD_MULTI = 1;
    static final short IORING_RECVSEND_POLL_FIRST = 1;
    static final short IORING_RECVSEND_BUNDLE = 16;
    static final short IORING_RECV_MULTISHOT = 2;
    static final short IORING_SEND_ZC_REPORT_USAGE = 8;
    static final int IORING_NOTIF_USAGE_ZC_COPIED = Integer.MIN_VALUE;
    static final short IORING_ACCEPT_MULTISHOT = 1;
    static final short IORING_ACCEPT_DONTWAIT = 2;
    static final short IORING_ACCEPT_POLL_FIRST = 4;
    static final int IORING_FEAT_NODROP = 2;
    static final int IORING_FEAT_SUBMIT_STABLE = 4;
    static final int IORING_FEAT_RECVSEND_BUNDLE = 16384;
    static final int IORING_SQ_NEED_WAKEUP = 1;
    static final int IORING_SQ_CQ_OVERFLOW = 2;
    static final int IORING_SQ_TASKRUN = 4;
    static final int SPLICE_F_MOVE = 1;
    static final int IOU_PBUF_RING_INC = 2;
    static final int IO_URING_OP_SUPPORTED = 1;
    static final int CQE_SIZE = 16;
    static final int CQE32_SIZE = 32;
    static final int IORING_ENTER_GETEVENTS;
    static final int IORING_ENTER_REGISTERED_RING = 16;
    static final int IOSQE_ASYNC;
    static final int IOSQE_LINK;
    static final int IOSQE_IO_DRAIN;
    static final int IOSQE_BUFFER_SELECT;
    static final int IOSQE_CQE_SKIP_SUCCESS = 64;
    static final int MSG_DONTWAIT;
    static final int MSG_FASTOPEN;
    static final int SOL_UDP;
    static final int SOL_SOCKET;
    static final int UDP_SEGMENT;
    static final int SCM_RIGHTS;
    private static final int TFO_ENABLED_CLIENT_MASK = 1;
    private static final int TFO_ENABLED_SERVER_MASK = 2;
    private static final int TCP_FASTOPEN_MODE;
    static final boolean IS_SUPPORTING_TCP_FASTOPEN_CLIENT;
    static final boolean IS_SUPPORTING_TCP_FASTOPEN_SERVER;
    private static final int[] REQUIRED_IORING_OPS;

    static String opToStr(byte op) {
        switch (op) {
            case 0: {
                return "NOP";
            }
            case 1: {
                return "READV";
            }
            case 2: {
                return "WRITEV";
            }
            case 3: {
                return "FSYNC";
            }
            case 4: {
                return "READ_FIXED";
            }
            case 5: {
                return "WRITE_FIXED";
            }
            case 6: {
                return "POLL_ADD";
            }
            case 7: {
                return "POLL_REMOVE";
            }
            case 8: {
                return "SYNC_FILE_RANGE";
            }
            case 9: {
                return "SENDMSG";
            }
            case 10: {
                return "RECVMSG";
            }
            case 11: {
                return "TIMEOUT";
            }
            case 12: {
                return "TIMEOUT_REMOVE";
            }
            case 13: {
                return "ACCEPT";
            }
            case 14: {
                return "ASYNC_CANCEL";
            }
            case 15: {
                return "LINK_TIMEOUT";
            }
            case 16: {
                return "CONNECT";
            }
            case 17: {
                return "FALLOCATE";
            }
            case 18: {
                return "OPENAT";
            }
            case 19: {
                return "CLOSE";
            }
            case 20: {
                return "FILES_UPDATE";
            }
            case 21: {
                return "STATX";
            }
            case 22: {
                return "READ";
            }
            case 23: {
                return "WRITE";
            }
            case 24: {
                return "FADVISE";
            }
            case 25: {
                return "MADVISE";
            }
            case 26: {
                return "SEND";
            }
            case 27: {
                return "RECV";
            }
            case 28: {
                return "OPENAT2";
            }
            case 29: {
                return "EPOLL_CTL";
            }
            case 30: {
                return "SPLICE";
            }
            case 31: {
                return "PROVIDE_BUFFERS";
            }
            case 32: {
                return "REMOVE_BUFFERS";
            }
            case 33: {
                return "TEE";
            }
            case 34: {
                return "SHUTDOWN";
            }
            case 35: {
                return "RENAMEAT";
            }
            case 36: {
                return "UNLINKAT";
            }
            case 37: {
                return "MKDIRAT";
            }
            case 38: {
                return "SYMLINKAT";
            }
            case 39: {
                return "LINKAT";
            }
        }
        return "[OP CODE " + op + "]";
    }

    static int setupFlags() {
        int flags = 80;
        if (IoUring.isSetupSubmitAllSupported()) {
            flags |= 0x80;
        }
        if (IoUring.isSetupSingleIssuerSupported()) {
            flags |= 0x1000;
        }
        if (IoUring.isSetupDeferTaskrunSupported()) {
            flags |= 0x2000;
        }
        if (IoUring.isIoringSetupNoSqarraySupported()) {
            flags |= 0x10000;
        }
        return flags;
    }

    static RingBuffer createRingBuffer(int ringSize, int setupFlags) {
        return Native.createRingBuffer(ringSize, ringSize * 2, setupFlags);
    }

    static RingBuffer createRingBuffer(int ringSize, int cqeSize, int setupFlags) {
        ObjectUtil.checkPositive(ringSize, "ringSize");
        ObjectUtil.checkPositive(cqeSize, "cqeSize");
        long[] values = Native.ioUringSetup(ringSize, cqeSize, setupFlags);
        assert (values.length == 20);
        long cqkhead = values[0];
        long cqktail = values[1];
        int cqringMask = (int)values[2];
        int cqringEntries = (int)values[3];
        long cqkflags = values[4];
        long cqArrayAddress = values[5];
        int cqringSize = (int)values[6];
        long cqringAddress = values[7];
        int cqringFd = (int)values[8];
        int cqringCapacity = (int)values[9];
        int cqeLength = (setupFlags & 0x800) == 0 ? 16 : 32;
        CompletionQueue completionQueue = new CompletionQueue(Buffer.wrapMemoryAddressWithNativeOrder(cqkhead, 4), Buffer.wrapMemoryAddressWithNativeOrder(cqktail, 4), cqringMask, cqringEntries, Buffer.wrapMemoryAddressWithNativeOrder(cqkflags, 4), Buffer.wrapMemoryAddressWithNativeOrder(cqArrayAddress, cqringEntries * cqeLength), cqringSize, cqringAddress, cqringFd, cqringCapacity, cqeLength);
        long sqkhead = values[10];
        long sqktail = values[11];
        int sqringMask = (int)values[12];
        int sqringEntries = (int)values[13];
        long sqkflags = values[14];
        long sqArrayAddress = values[15];
        int sqringSize = (int)values[16];
        long sqringAddress = values[17];
        int sqringFd = (int)values[18];
        SubmissionQueue submissionQueue = new SubmissionQueue(Buffer.wrapMemoryAddressWithNativeOrder(sqkhead, 4), Buffer.wrapMemoryAddressWithNativeOrder(sqktail, 4), sqringMask, sqringEntries, Buffer.wrapMemoryAddressWithNativeOrder(sqkflags, 4), Buffer.wrapMemoryAddressWithNativeOrder(sqArrayAddress, sqringEntries * 64), sqringSize, sqringAddress, sqringFd);
        return new RingBuffer(submissionQueue, completionQueue, (int)values[19]);
    }

    static void checkAllIOSupported(IoUringProbe probe) {
        if (!Native.ioUringProbe(probe, REQUIRED_IORING_OPS)) {
            throw new UnsupportedOperationException("Not all operations are supported: " + Arrays.toString(REQUIRED_IORING_OPS));
        }
    }

    static boolean isRecvMultishotSupported() {
        return Native.ioUringSetupSupportsFlags(4096);
    }

    static boolean isAcceptMultishotSupported(IoUringProbe probe) {
        return Native.ioUringProbe(probe, new int[]{45});
    }

    static boolean isCqeFSockNonEmptySupported(IoUringProbe probe) {
        return Native.ioUringProbe(probe, new int[]{45});
    }

    static boolean isSpliceSupported(IoUringProbe probe) {
        return Native.ioUringProbe(probe, new int[]{30});
    }

    static boolean isPollAddMultiShotSupported(IoUringProbe probe) {
        return Native.isCqeFSockNonEmptySupported(probe);
    }

    static boolean isSendZcSupported(IoUringProbe probe) {
        return Native.ioUringProbe(probe, new int[]{47});
    }

    static boolean isSendmsgZcSupported(IoUringProbe probe) {
        return Native.ioUringProbe(probe, new int[]{48});
    }

    static boolean isRegisterIoWqWorkerSupported(int ringFd) {
        int result = Native.ioUringRegisterIoWqMaxWorkers(ringFd, 0, 0);
        return result >= 0;
    }

    static boolean isRegisterBufferRingSupported(int ringFd, int flags) {
        int entries = 2;
        short bgid = 1;
        long result = Native.ioUringRegisterBufRing(ringFd, entries, bgid, flags);
        if (result >= 0L) {
            Native.ioUringUnRegisterBufRing(ringFd, result, entries, bgid);
            return true;
        }
        return false;
    }

    static void checkKernelVersion(String kernelVersion) {
        boolean enforceKernelVersion = SystemPropertyUtil.getBoolean("io.netty.transport.iouring.enforceKernelVersion", true);
        boolean kernelSupported = Native.checkKernelVersion(kernelVersion, 5, 9);
        if (!kernelSupported) {
            if (enforceKernelVersion) {
                throw new UnsupportedOperationException("you need at least kernel version 5.9, current kernel version: " + kernelVersion);
            }
            logger.debug("Detected kernel " + kernelVersion + " does not match minimum version of 5.9, trying to use io_uring anyway");
        }
    }

    private static boolean checkKernelVersion(String kernelVersion, int major, int minor) {
        int nativeMinor;
        int nativeMajor;
        String[] versionComponents = kernelVersion.split("\\.");
        if (versionComponents.length < 3) {
            return false;
        }
        try {
            nativeMajor = Integer.parseInt(versionComponents[0]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        if (nativeMajor < major) {
            return false;
        }
        if (nativeMajor > major) {
            return true;
        }
        try {
            nativeMinor = Integer.parseInt(versionComponents[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return nativeMinor >= minor;
    }

    static boolean ioUringProbe(IoUringProbe probe, int[] ops) {
        IoUringProbeOp[] ioUringProbeOps = probe.ops;
        if (ioUringProbeOps == null) {
            return false;
        }
        for (int op : ops) {
            if (op <= probe.lastOp && (ioUringProbeOps[op].flags & 1) != 0) continue;
            return false;
        }
        return true;
    }

    static native boolean ioUringSetupSupportsFlags(int var0);

    private static native long[] ioUringSetup(int var0, int var1, int var2);

    static IoUringProbe ioUringProbe(int ringfd) {
        int[] values = Native.ioUringProbe0(ringfd);
        if (values == null) {
            return null;
        }
        return new IoUringProbe(values);
    }

    private static native int[] ioUringProbe0(int var0);

    static native int ioUringRegisterIoWqMaxWorkers(int var0, int var1, int var2);

    static native int ioUringRegisterEnableRings(int var0);

    static native int ioUringRegisterRingFds(int var0);

    static native long ioUringRegisterBufRing(int var0, int var1, short var2, int var3);

    static native int ioUringUnRegisterBufRing(int var0, long var1, int var3, short var4);

    static native int ioUringBufRingSize(int var0);

    static native int ioUringEnter(int var0, int var1, int var2, int var3);

    static native void eventFdWrite(int var0, long var1);

    static int getFd(DefaultFileRegion fileChannel) {
        return Native.getFd0(fileChannel);
    }

    private static native int getFd0(Object var0);

    static FileDescriptor newBlockingEventFd() {
        return new FileDescriptor(Native.blockingEventFd());
    }

    static native void ioUringExit(long var0, int var2, long var3, int var5, long var6, int var8, int var9, int var10);

    private static native int blockingEventFd();

    static native int createFile(String var0);

    private static native int registerUnix();

    static native long cmsghdrData(long var0);

    static native String kernelVersion();

    private Native() {
    }

    private static void loadNativeLibrary() {
        String name = PlatformDependent.normalizedOs().toLowerCase(Locale.ROOT).trim();
        if (!name.startsWith("linux")) {
            throw new IllegalStateException("Only supported on Linux");
        }
        String staticLibName = "netty_transport_native_io_uring42";
        String sharedLibName = staticLibName + "_" + PlatformDependent.normalizedArch();
        ClassLoader cl = PlatformDependent.getClassLoader(Native.class);
        try {
            NativeLibraryLoader.load(sharedLibName, cl);
        }
        catch (UnsatisfiedLinkError e1) {
            try {
                NativeLibraryLoader.load(staticLibName, cl);
                logger.info("Failed to load io_uring");
            }
            catch (UnsatisfiedLinkError e2) {
                ThrowableUtil.addSuppressed((Throwable)e1, e2);
                throw e1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        ClassInitializerUtil.tryLoadClasses(Native.class, PeerCredentials.class, java.io.FileDescriptor.class);
        File tmpDir = PlatformDependent.tmpdir();
        Path tmpFile = tmpDir.toPath().resolve("netty_io_uring.tmp");
        try {
            Native.createFile(tmpFile.toString());
        }
        catch (UnsatisfiedLinkError ignore) {
            Native.loadNativeLibrary();
        }
        finally {
            tmpFile.toFile().delete();
            try {
                if (selector != null) {
                    selector.close();
                }
            }
            catch (IOException iOException) {}
        }
        Unix.registerInternal(Native::registerUnix);
        SOCK_NONBLOCK = NativeStaticallyReferencedJniMethods.sockNonblock();
        SOCK_CLOEXEC = NativeStaticallyReferencedJniMethods.sockCloexec();
        AF_INET = (short)NativeStaticallyReferencedJniMethods.afInet();
        AF_INET6 = (short)NativeStaticallyReferencedJniMethods.afInet6();
        AF_UNIX = (short)NativeStaticallyReferencedJniMethods.afUnix();
        SIZEOF_SOCKADDR_STORAGE = NativeStaticallyReferencedJniMethods.sizeofSockaddrStorage();
        SIZEOF_SOCKADDR_UN = NativeStaticallyReferencedJniMethods.sizeofSockaddrUn();
        SOCKADDR_UN_OFFSETOF_SUN_FAMILY = NativeStaticallyReferencedJniMethods.sockaddrUnOffsetofSunFamily();
        SOCKADDR_UN_OFFSETOF_SUN_PATH = NativeStaticallyReferencedJniMethods.sockaddrUnOffsetofSunPath();
        MAX_SUN_PATH_LEN = NativeStaticallyReferencedJniMethods.maxSunPathLen();
        SIZEOF_SOCKADDR_IN = NativeStaticallyReferencedJniMethods.sizeofSockaddrIn();
        SIZEOF_SOCKADDR_IN6 = NativeStaticallyReferencedJniMethods.sizeofSockaddrIn6();
        SOCKADDR_IN_OFFSETOF_SIN_FAMILY = NativeStaticallyReferencedJniMethods.sockaddrInOffsetofSinFamily();
        SOCKADDR_IN_OFFSETOF_SIN_PORT = NativeStaticallyReferencedJniMethods.sockaddrInOffsetofSinPort();
        SOCKADDR_IN_OFFSETOF_SIN_ADDR = NativeStaticallyReferencedJniMethods.sockaddrInOffsetofSinAddr();
        IN_ADDRESS_OFFSETOF_S_ADDR = NativeStaticallyReferencedJniMethods.inAddressOffsetofSAddr();
        SOCKADDR_IN6_OFFSETOF_SIN6_FAMILY = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6Family();
        SOCKADDR_IN6_OFFSETOF_SIN6_PORT = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6Port();
        SOCKADDR_IN6_OFFSETOF_SIN6_FLOWINFO = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6Flowinfo();
        SOCKADDR_IN6_OFFSETOF_SIN6_ADDR = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6Addr();
        SOCKADDR_IN6_OFFSETOF_SIN6_SCOPE_ID = NativeStaticallyReferencedJniMethods.sockaddrIn6OffsetofSin6ScopeId();
        IN6_ADDRESS_OFFSETOF_S6_ADDR = NativeStaticallyReferencedJniMethods.in6AddressOffsetofS6Addr();
        SIZEOF_SIZE_T = NativeStaticallyReferencedJniMethods.sizeofSizeT();
        SIZEOF_IOVEC = NativeStaticallyReferencedJniMethods.sizeofIovec();
        CMSG_SPACE = NativeStaticallyReferencedJniMethods.cmsgSpace();
        CMSG_SPACE_FOR_FD = NativeStaticallyReferencedJniMethods.cmsgSpaceForFd();
        CMSG_LEN = NativeStaticallyReferencedJniMethods.cmsgLen();
        CMSG_LEN_FOR_FD = NativeStaticallyReferencedJniMethods.cmsgLenForFd();
        MSG_CONTROL_LEN_FOR_FD = NativeStaticallyReferencedJniMethods.msgControlLenForFd();
        CMSG_OFFSETOF_CMSG_LEN = NativeStaticallyReferencedJniMethods.cmsghdrOffsetofCmsgLen();
        CMSG_OFFSETOF_CMSG_LEVEL = NativeStaticallyReferencedJniMethods.cmsghdrOffsetofCmsgLevel();
        CMSG_OFFSETOF_CMSG_TYPE = NativeStaticallyReferencedJniMethods.cmsghdrOffsetofCmsgType();
        IO_URING_BUFFER_RING_TAIL = NativeStaticallyReferencedJniMethods.ioUringBufferRingOffsetTail();
        IOVEC_OFFSETOF_IOV_BASE = NativeStaticallyReferencedJniMethods.iovecOffsetofIovBase();
        IOVEC_OFFSETOF_IOV_LEN = NativeStaticallyReferencedJniMethods.iovecOffsetofIovLen();
        SIZEOF_MSGHDR = NativeStaticallyReferencedJniMethods.sizeofMsghdr();
        MSGHDR_OFFSETOF_MSG_NAME = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgName();
        MSGHDR_OFFSETOF_MSG_NAMELEN = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgNamelen();
        MSGHDR_OFFSETOF_MSG_IOV = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgIov();
        MSGHDR_OFFSETOF_MSG_IOVLEN = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgIovlen();
        MSGHDR_OFFSETOF_MSG_CONTROL = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgControl();
        MSGHDR_OFFSETOF_MSG_CONTROLLEN = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgControllen();
        MSGHDR_OFFSETOF_MSG_FLAGS = NativeStaticallyReferencedJniMethods.msghdrOffsetofMsgFlags();
        POLLIN = NativeStaticallyReferencedJniMethods.pollin();
        POLLOUT = NativeStaticallyReferencedJniMethods.pollout();
        POLLRDHUP = NativeStaticallyReferencedJniMethods.pollrdhup();
        ERRNO_ECANCELED_NEGATIVE = -NativeStaticallyReferencedJniMethods.ecanceled();
        ERRNO_ETIME_NEGATIVE = -NativeStaticallyReferencedJniMethods.etime();
        ERRNO_NOBUFS_NEGATIVE = -NativeStaticallyReferencedJniMethods.enobufs();
        PAGE_SIZE = NativeStaticallyReferencedJniMethods.pageSize();
        MAX_SKB_FRAGS = NativeStaticallyReferencedJniMethods.maxSkbFrags();
        SIZEOF_IOURING_BUF = NativeStaticallyReferencedJniMethods.sizeofIoUringBuf();
        IOURING_BUFFER_OFFSETOF_ADDR = NativeStaticallyReferencedJniMethods.ioUringBufferOffsetAddr();
        IOURING_BUFFER_OFFSETOF_LEN = NativeStaticallyReferencedJniMethods.ioUringBufferOffsetLen();
        IOURING_BUFFER_OFFSETOF_BID = NativeStaticallyReferencedJniMethods.ioUringBufferOffsetBid();
        IORING_ENTER_GETEVENTS = NativeStaticallyReferencedJniMethods.ioringEnterGetevents();
        IOSQE_ASYNC = NativeStaticallyReferencedJniMethods.iosqeAsync();
        IOSQE_LINK = NativeStaticallyReferencedJniMethods.iosqeLink();
        IOSQE_IO_DRAIN = NativeStaticallyReferencedJniMethods.iosqeDrain();
        IOSQE_BUFFER_SELECT = NativeStaticallyReferencedJniMethods.iosqeBufferSelect();
        MSG_DONTWAIT = NativeStaticallyReferencedJniMethods.msgDontwait();
        MSG_FASTOPEN = NativeStaticallyReferencedJniMethods.msgFastopen();
        SOL_UDP = NativeStaticallyReferencedJniMethods.solUdp();
        SOL_SOCKET = NativeStaticallyReferencedJniMethods.solSocket();
        UDP_SEGMENT = NativeStaticallyReferencedJniMethods.udpSegment();
        SCM_RIGHTS = NativeStaticallyReferencedJniMethods.scmRights();
        TCP_FASTOPEN_MODE = NativeStaticallyReferencedJniMethods.tcpFastopenMode();
        IS_SUPPORTING_TCP_FASTOPEN_CLIENT = (TCP_FASTOPEN_MODE & 1) == 1;
        IS_SUPPORTING_TCP_FASTOPEN_SERVER = (TCP_FASTOPEN_MODE & 2) == 2;
        REQUIRED_IORING_OPS = new int[]{6, 11, 13, 22, 23, 7, 16, 19, 2, 9, 10, 14, 27, 0, 34, 26};
    }

    static class IoUringProbeOp {
        final byte op;
        final int flags;

        IoUringProbeOp(byte op, int flags) {
            this.op = op;
            this.flags = flags;
        }
    }

    static final class IoUringProbe {
        final byte lastOp;
        final byte opsLen;
        final IoUringProbeOp[] ops;

        IoUringProbe(int[] values) {
            int idx = 0;
            this.lastOp = (byte)values[idx++];
            this.opsLen = (byte)values[idx++];
            this.ops = new IoUringProbeOp[this.opsLen];
            for (int i = 0; i < this.opsLen; ++i) {
                this.ops[i] = new IoUringProbeOp((byte)values[idx++], values[idx++]);
            }
        }
    }
}

