/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.proxy.ProxyInitializeEvent;
import com.velocitypowered.api.event.proxy.ProxyReloadEvent;
import com.velocitypowered.api.event.proxy.ProxyShutdownEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginManager;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.api.util.Favicon;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.api.util.ProxyVersion;
import com.velocitypowered.proxy.Metrics;
import com.velocitypowered.proxy.ProxyOptions;
import com.velocitypowered.proxy.bstats.MetricsBase;
import com.velocitypowered.proxy.command.VelocityCommandManager;
import com.velocitypowered.proxy.command.builtin.CallbackCommand;
import com.velocitypowered.proxy.command.builtin.GlistCommand;
import com.velocitypowered.proxy.command.builtin.SendCommand;
import com.velocitypowered.proxy.command.builtin.ServerCommand;
import com.velocitypowered.proxy.command.builtin.ShutdownCommand;
import com.velocitypowered.proxy.command.builtin.VelocityCommand;
import com.velocitypowered.proxy.config.VelocityConfiguration;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.player.resourcepack.VelocityResourcePackInfo;
import com.velocitypowered.proxy.connection.util.ServerListPingHandler;
import com.velocitypowered.proxy.console.VelocityConsole;
import com.velocitypowered.proxy.crypto.EncryptionUtils;
import com.velocitypowered.proxy.event.VelocityEventManager;
import com.velocitypowered.proxy.network.ConnectionManager;
import com.velocitypowered.proxy.plugin.VelocityPluginManager;
import com.velocitypowered.proxy.plugin.loader.VelocityPluginContainer;
import com.velocitypowered.proxy.plugin.loader.VelocityPluginDescription;
import com.velocitypowered.proxy.plugin.virtual.VelocityVirtualPlugin;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.util.FaviconSerializer;
import com.velocitypowered.proxy.protocol.util.GameProfileSerializer;
import com.velocitypowered.proxy.scheduler.VelocityScheduler;
import com.velocitypowered.proxy.server.ServerMap;
import com.velocitypowered.proxy.util.AddressUtil;
import com.velocitypowered.proxy.util.ClosestLocaleMatcher;
import com.velocitypowered.proxy.util.ResourceUtils;
import com.velocitypowered.proxy.util.VelocityChannelRegistrar;
import com.velocitypowered.proxy.util.ratelimit.Ratelimiter;
import com.velocitypowered.proxy.util.ratelimit.Ratelimiters;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.http.HttpClient;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.audience.ForwardingAudience;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.EnsuresNonNull;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class VelocityServer
implements ProxyServer,
ForwardingAudience {
    public static final String VELOCITY_URL = "https://velocitypowered.com";
    private static final Logger logger = LogManager.getLogger(VelocityServer.class);
    public static final Gson GENERAL_GSON = new GsonBuilder().registerTypeHierarchyAdapter(Favicon.class, FaviconSerializer.INSTANCE).registerTypeHierarchyAdapter(GameProfile.class, GameProfileSerializer.INSTANCE).create();
    private static final Gson PRE_1_16_PING_SERIALIZER = new GsonBuilder().registerTypeHierarchyAdapter(Component.class, ProtocolUtils.getJsonChatSerializer(ProtocolVersion.MINECRAFT_1_15_2).serializer().getAdapter(Component.class)).registerTypeHierarchyAdapter(Favicon.class, FaviconSerializer.INSTANCE).create();
    private static final Gson PRE_1_20_3_PING_SERIALIZER = new GsonBuilder().registerTypeHierarchyAdapter(Component.class, ProtocolUtils.getJsonChatSerializer(ProtocolVersion.MINECRAFT_1_20_2).serializer().getAdapter(Component.class)).registerTypeHierarchyAdapter(Favicon.class, FaviconSerializer.INSTANCE).create();
    private static final Gson MODERN_PING_SERIALIZER = new GsonBuilder().registerTypeHierarchyAdapter(Component.class, ProtocolUtils.getJsonChatSerializer(ProtocolVersion.MINECRAFT_1_20_3).serializer().getAdapter(Component.class)).registerTypeHierarchyAdapter(Favicon.class, FaviconSerializer.INSTANCE).create();
    private final ConnectionManager cm;
    private final ProxyOptions options;
    private @MonotonicNonNull VelocityConfiguration configuration;
    private @MonotonicNonNull KeyPair serverKeyPair;
    private final ServerMap servers;
    private final VelocityCommandManager commandManager;
    private final AtomicBoolean shutdownInProgress = new AtomicBoolean(false);
    private boolean shutdown = false;
    private final VelocityPluginManager pluginManager;
    private final Map<UUID, ConnectedPlayer> connectionsByUuid = new ConcurrentHashMap<UUID, ConnectedPlayer>();
    private final Map<String, ConnectedPlayer> connectionsByName = new ConcurrentHashMap<String, ConnectedPlayer>();
    private final VelocityConsole console;
    private @MonotonicNonNull Ratelimiter ipAttemptLimiter;
    private final VelocityEventManager eventManager;
    private final VelocityScheduler scheduler;
    private final VelocityChannelRegistrar channelRegistrar = new VelocityChannelRegistrar();
    private final ServerListPingHandler serverListPingHandler;

    VelocityServer(ProxyOptions options) {
        this.pluginManager = new VelocityPluginManager(this);
        this.eventManager = new VelocityEventManager(this.pluginManager);
        this.commandManager = new VelocityCommandManager(this.eventManager, this.pluginManager);
        this.scheduler = new VelocityScheduler(this.pluginManager);
        this.console = new VelocityConsole(this);
        this.cm = new ConnectionManager(this);
        this.servers = new ServerMap(this);
        this.serverListPingHandler = new ServerListPingHandler(this);
        this.options = options;
    }

    public KeyPair getServerKeyPair() {
        return this.serverKeyPair;
    }

    @Override
    public VelocityConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public ProxyVersion getVersion() {
        String implVendor;
        String implVersion;
        String implName;
        Package pkg = VelocityServer.class.getPackage();
        if (pkg != null) {
            implName = MoreObjects.firstNonNull(pkg.getImplementationTitle(), "Velocity");
            implVersion = MoreObjects.firstNonNull(pkg.getImplementationVersion(), "<unknown>");
            implVendor = MoreObjects.firstNonNull(pkg.getImplementationVendor(), "Velocity Contributors");
        } else {
            implName = "Velocity";
            implVersion = "<unknown>";
            implVendor = "Velocity Contributors";
        }
        return new ProxyVersion(implName, implVendor, implVersion);
    }

    private VelocityPluginContainer createVirtualPlugin() {
        ProxyVersion version = this.getVersion();
        VelocityPluginDescription description = new VelocityPluginDescription("velocity", version.getName(), version.getVersion(), "The Velocity proxy", VELOCITY_URL, ImmutableList.of(version.getVendor()), Collections.emptyList(), null);
        VelocityPluginContainer container = new VelocityPluginContainer(description);
        container.setInstance(VelocityVirtualPlugin.INSTANCE);
        return container;
    }

    @Override
    public VelocityCommandManager getCommandManager() {
        return this.commandManager;
    }

    void awaitProxyShutdown() {
        this.cm.getBossGroup().terminationFuture().syncUninterruptibly();
    }

    @EnsuresNonNull(value={"serverKeyPair", "servers", "pluginManager", "eventManager", "scheduler", "console", "cm", "configuration"})
    void start() {
        logger.info("Booting up {} {}...", (Object)this.getVersion().getName(), (Object)this.getVersion().getVersion());
        this.console.setupStreams();
        this.pluginManager.registerPlugin(this.createVirtualPlugin());
        this.registerTranslations();
        this.serverKeyPair = EncryptionUtils.createRsaKeyPair(1024);
        this.cm.logChannelInformation();
        BrigadierCommand velocityParentCommand = VelocityCommand.create(this);
        this.commandManager.register(this.commandManager.metaBuilder(velocityParentCommand).plugin(VelocityVirtualPlugin.INSTANCE).build(), velocityParentCommand);
        BrigadierCommand callbackCommand = CallbackCommand.create();
        this.commandManager.register(this.commandManager.metaBuilder(callbackCommand).plugin(VelocityVirtualPlugin.INSTANCE).build(), velocityParentCommand);
        BrigadierCommand serverCommand = ServerCommand.create(this);
        this.commandManager.register(this.commandManager.metaBuilder(serverCommand).plugin(VelocityVirtualPlugin.INSTANCE).build(), serverCommand);
        BrigadierCommand shutdownCommand = ShutdownCommand.command(this);
        this.commandManager.register(this.commandManager.metaBuilder(shutdownCommand).plugin(VelocityVirtualPlugin.INSTANCE).aliases("end", "stop").build(), shutdownCommand);
        new GlistCommand(this).register();
        new SendCommand(this).register();
        this.doStartupConfigLoad();
        for (ServerInfo serverInfo : this.options.getServers()) {
            this.servers.register(serverInfo);
        }
        if (!this.options.isIgnoreConfigServers()) {
            for (Map.Entry entry : this.configuration.getServers().entrySet()) {
                this.servers.register(new ServerInfo((String)entry.getKey(), AddressUtil.parseAddress((String)entry.getValue())));
            }
        }
        this.ipAttemptLimiter = Ratelimiters.createWithMilliseconds(this.configuration.getLoginRatelimit());
        this.loadPlugins();
        this.eventManager.fire(new ProxyInitializeEvent()).join();
        this.console.setupPermissions();
        Integer port = this.options.getPort();
        if (port != null) {
            logger.debug("Overriding bind port to {} from command line option", (Object)port);
            this.cm.bind(new InetSocketAddress(this.configuration.getBind().getHostString(), (int)port));
        } else {
            this.cm.bind(this.configuration.getBind());
        }
        Boolean bl = this.options.isHaproxy();
        if (bl != null) {
            logger.debug("Overriding HAProxy protocol to {} from command line option", (Object)bl);
            this.configuration.setProxyProtocol(bl);
        }
        if (this.configuration.isQueryEnabled()) {
            this.cm.queryBind(this.configuration.getBind().getHostString(), this.configuration.getQueryPort());
        }
        String defaultPackage = new String(new byte[]{111, 114, 103, 46, 98, 115, 116, 97, 116, 115});
        if (!MetricsBase.class.getPackage().getName().startsWith(defaultPackage)) {
            Metrics.VelocityMetrics.startMetrics(this, this.configuration.getMetrics());
        } else {
            logger.warn("debug environment, metrics is disabled!");
        }
    }

    private void registerTranslations() {
        TranslationRegistry translationRegistry = TranslationRegistry.create(Key.key("velocity", "translations"));
        translationRegistry.defaultLocale(Locale.US);
        try {
            ResourceUtils.visitResources(VelocityServer.class, path -> {
                logger.info("Loading localizations...");
                Path langPath = Path.of("lang", new String[0]);
                try {
                    Stream<Path> files;
                    if (!Files.exists(langPath, new LinkOption[0])) {
                        Files.createDirectory(langPath, new FileAttribute[0]);
                        files = Files.walk(path, new FileVisitOption[0]);
                        try {
                            files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                                block8: {
                                    try {
                                        Path langFile = langPath.resolve(file.getFileName().toString());
                                        if (Files.exists(langFile, new LinkOption[0])) break block8;
                                        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
                                            Files.copy(is, langFile, new CopyOption[0]);
                                        }
                                    }
                                    catch (IOException e) {
                                        logger.error("Encountered an I/O error whilst loading translations", (Throwable)e);
                                    }
                                }
                            });
                        }
                        finally {
                            if (files != null) {
                                files.close();
                            }
                        }
                    }
                    files = Files.walk(langPath, new FileVisitOption[0]);
                    try {
                        files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(file -> {
                            String filename = com.google.common.io.Files.getNameWithoutExtension(file.getFileName().toString());
                            String localeName = filename.replace("messages_", "").replace("messages", "").replace('_', '-');
                            Locale locale = localeName.isBlank() ? Locale.US : Locale.forLanguageTag(localeName);
                            translationRegistry.registerAll(locale, (Path)file, false);
                            ClosestLocaleMatcher.INSTANCE.registerKnown(locale);
                        });
                    }
                    finally {
                        if (files != null) {
                            files.close();
                        }
                    }
                }
                catch (IOException e) {
                    logger.error("Encountered an I/O error whilst loading translations", (Throwable)e);
                }
            }, "com", "velocitypowered", "proxy", "l10n");
        }
        catch (IOException e) {
            logger.error("Encountered an I/O error whilst loading translations", (Throwable)e);
            return;
        }
        GlobalTranslator.translator().addSource(translationRegistry);
    }

    @SuppressFBWarnings(value={"DM_EXIT"})
    private void doStartupConfigLoad() {
        try {
            Path configPath = Path.of("velocity.toml", new String[0]);
            this.configuration = VelocityConfiguration.read(configPath);
            if (!this.configuration.validate()) {
                logger.error("Your configuration is invalid. Velocity will not start up until the errors are resolved.");
                LogManager.shutdown();
                System.exit(1);
            }
            this.commandManager.setAnnounceProxyCommands(this.configuration.isAnnounceProxyCommands());
        }
        catch (Exception e) {
            logger.error("Unable to read/load/save your velocity.toml. The server will shut down.", (Throwable)e);
            LogManager.shutdown();
            System.exit(1);
        }
    }

    private void loadPlugins() {
        logger.info("Loading plugins...");
        try {
            Path pluginPath = Path.of("plugins", new String[0]);
            if (!pluginPath.toFile().exists()) {
                Files.createDirectory(pluginPath, new FileAttribute[0]);
            } else {
                if (!pluginPath.toFile().isDirectory()) {
                    logger.warn("Plugin location {} is not a directory, continuing without loading plugins", (Object)pluginPath);
                    return;
                }
                this.pluginManager.loadPlugins(pluginPath);
            }
        }
        catch (Exception e) {
            logger.error("Couldn't load plugins", (Throwable)e);
        }
        for (PluginContainer plugin : this.pluginManager.getPlugins()) {
            Optional<?> instance = plugin.getInstance();
            if (!instance.isPresent()) continue;
            try {
                this.eventManager.registerInternally(plugin, instance.get());
            }
            catch (Exception e) {
                logger.error("Unable to register plugin listener for {}", (Object)plugin.getDescription().getName().orElse(plugin.getDescription().getId()), (Object)e);
            }
        }
        logger.info("Loaded {} plugins", (Object)this.pluginManager.getPlugins().size());
    }

    public Bootstrap createBootstrap(@Nullable EventLoopGroup group) {
        return this.cm.createWorker(group);
    }

    public ChannelInitializer<Channel> getBackendChannelInitializer() {
        return this.cm.backendChannelInitializer.get();
    }

    public ServerListPingHandler getServerListPingHandler() {
        return this.serverListPingHandler;
    }

    public boolean isShutdown() {
        return this.shutdown;
    }

    public boolean reloadConfiguration() throws IOException {
        Path configPath = Path.of("velocity.toml", new String[0]);
        VelocityConfiguration newConfiguration = VelocityConfiguration.read(configPath);
        if (!newConfiguration.validate()) {
            return false;
        }
        ArrayList<ConnectedPlayer> evacuate = new ArrayList<ConnectedPlayer>();
        for (Map.Entry<String, String> entry : newConfiguration.getServers().entrySet()) {
            ServerInfo newInfo = new ServerInfo(entry.getKey(), AddressUtil.parseAddress(entry.getValue()));
            Optional<RegisteredServer> rs = this.servers.getServer(entry.getKey());
            if (rs.isEmpty()) {
                this.servers.register(newInfo);
                continue;
            }
            if (rs.get().getServerInfo().equals(newInfo)) continue;
            for (Player player : rs.get().getPlayersConnected()) {
                if (!(player instanceof ConnectedPlayer)) {
                    throw new IllegalStateException("ConnectedPlayer not found for player " + player + " in server " + rs.get().getServerInfo().getName());
                }
                evacuate.add((ConnectedPlayer)player);
            }
            this.servers.unregister(rs.get().getServerInfo());
            this.servers.register(newInfo);
        }
        if (!evacuate.isEmpty()) {
            CountDownLatch latch = new CountDownLatch(evacuate.size());
            for (ConnectedPlayer player : evacuate) {
                Optional<RegisteredServer> next = player.getNextServerToTry();
                if (next.isPresent()) {
                    player.createConnectionRequest(next.get()).connectWithIndication().whenComplete((success, ex) -> {
                        if (ex != null || success == null || !success.booleanValue()) {
                            player.disconnect(Component.text("Your server has been changed, but we could not move you to any fallback servers."));
                        }
                        latch.countDown();
                    });
                    continue;
                }
                latch.countDown();
                player.disconnect(Component.text("Your server has been changed, but we could not move you to any fallback servers."));
            }
            try {
                latch.await();
            }
            catch (InterruptedException interruptedException) {
                logger.error("Interrupted whilst moving players", (Throwable)interruptedException);
                Thread.currentThread().interrupt();
            }
        }
        if (!this.configuration.getBind().equals(newConfiguration.getBind())) {
            this.cm.bind(newConfiguration.getBind());
            this.cm.close(this.configuration.getBind());
        }
        boolean queryPortChanged = newConfiguration.getQueryPort() != this.configuration.getQueryPort();
        boolean bl = this.configuration.isQueryEnabled();
        boolean queryEnabled = newConfiguration.isQueryEnabled();
        if (bl && (!queryEnabled || queryPortChanged)) {
            this.cm.close(new InetSocketAddress(this.configuration.getBind().getHostString(), this.configuration.getQueryPort()));
        }
        if (queryEnabled && (!bl || queryPortChanged)) {
            this.cm.queryBind(newConfiguration.getBind().getHostString(), newConfiguration.getQueryPort());
        }
        this.commandManager.setAnnounceProxyCommands(newConfiguration.isAnnounceProxyCommands());
        this.ipAttemptLimiter = Ratelimiters.createWithMilliseconds(newConfiguration.getLoginRatelimit());
        this.configuration = newConfiguration;
        this.eventManager.fireAndForget(new ProxyReloadEvent());
        return true;
    }

    public void shutdown(boolean explicitExit, Component reason) {
        if (this.eventManager == null || this.pluginManager == null || this.cm == null || this.scheduler == null) {
            throw new AssertionError();
        }
        if (!this.shutdownInProgress.compareAndSet(false, true)) {
            return;
        }
        Runnable shutdownProcess = () -> {
            logger.info("Shutting down the proxy...");
            this.cm.shutdown();
            ImmutableList<ConnectedPlayer> players = ImmutableList.copyOf(this.connectionsByUuid.values());
            for (ConnectedPlayer player : players) {
                player.disconnect(reason);
            }
            try {
                boolean timedOut = false;
                try {
                    CompletableFuture<Void> playersTeardownFuture = CompletableFuture.allOf((CompletableFuture[])players.stream().map(ConnectedPlayer::getTeardownFuture).toArray(CompletableFuture[]::new));
                    playersTeardownFuture.get(10L, TimeUnit.SECONDS);
                }
                catch (TimeoutException e) {
                    timedOut = true;
                }
                catch (ExecutionException e) {
                    timedOut = true;
                    logger.error("Exception while tearing down player connections", (Throwable)e);
                }
                this.eventManager.fire(new ProxyShutdownEvent()).join();
                boolean bl = timedOut = !this.scheduler.shutdown() || timedOut;
                if (timedOut) {
                    logger.error("Your plugins took over 10 seconds to shut down.");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            LogManager.shutdown();
            this.shutdown = true;
            if (explicitExit) {
                System.exit(0);
            }
        };
        if (explicitExit) {
            Thread thread = new Thread(shutdownProcess);
            thread.start();
        } else {
            shutdownProcess.run();
        }
    }

    public void shutdown(boolean explicitExit) {
        this.shutdown(explicitExit, Component.translatable("velocity.kick.shutdown"));
    }

    @Override
    public void shutdown(Component reason) {
        this.shutdown(true, reason);
    }

    @Override
    public void shutdown() {
        this.shutdown(true);
    }

    @Override
    public void closeListeners() {
        this.cm.closeEndpoints(false);
    }

    public HttpClient createHttpClient() {
        return this.cm.createHttpClient();
    }

    public Ratelimiter getIpAttemptLimiter() {
        return this.ipAttemptLimiter;
    }

    public boolean canRegisterConnection(ConnectedPlayer connection) {
        if (this.configuration.isOnlineMode() && this.configuration.isOnlineModeKickExistingPlayers()) {
            return true;
        }
        String lowerName = connection.getUsername().toLowerCase(Locale.US);
        return !this.connectionsByName.containsKey(lowerName) && !this.connectionsByUuid.containsKey(connection.getUniqueId());
    }

    public boolean registerConnection(ConnectedPlayer connection) {
        String lowerName = connection.getUsername().toLowerCase(Locale.US);
        if (!this.configuration.isOnlineModeKickExistingPlayers()) {
            if (this.connectionsByName.putIfAbsent(lowerName, connection) != null) {
                return false;
            }
            if (this.connectionsByUuid.putIfAbsent(connection.getUniqueId(), connection) != null) {
                this.connectionsByName.remove(lowerName, connection);
                return false;
            }
        } else {
            ConnectedPlayer existing = this.connectionsByUuid.get(connection.getUniqueId());
            if (existing != null) {
                existing.disconnect(Component.translatable("multiplayer.disconnect.duplicate_login"));
            }
            this.connectionsByName.put(lowerName, connection);
            this.connectionsByUuid.put(connection.getUniqueId(), connection);
        }
        return true;
    }

    public void unregisterConnection(ConnectedPlayer connection) {
        this.connectionsByName.remove(connection.getUsername().toLowerCase(Locale.US), connection);
        this.connectionsByUuid.remove(connection.getUniqueId(), connection);
        connection.disconnected();
    }

    @Override
    public Optional<Player> getPlayer(String username) {
        Preconditions.checkNotNull(username, "username");
        return Optional.ofNullable((Player)this.connectionsByName.get(username.toLowerCase(Locale.US)));
    }

    @Override
    public Optional<Player> getPlayer(UUID uuid) {
        Preconditions.checkNotNull(uuid, "uuid");
        return Optional.ofNullable((Player)this.connectionsByUuid.get(uuid));
    }

    @Override
    public Collection<Player> matchPlayer(String partialName) {
        Objects.requireNonNull(partialName);
        return this.getAllPlayers().stream().filter(p -> p.getUsername().regionMatches(true, 0, partialName, 0, partialName.length())).collect(Collectors.toList());
    }

    @Override
    public Collection<RegisteredServer> matchServer(String partialName) {
        Objects.requireNonNull(partialName);
        return this.getAllServers().stream().filter(s -> s.getServerInfo().getName().regionMatches(true, 0, partialName, 0, partialName.length())).collect(Collectors.toList());
    }

    @Override
    public Collection<Player> getAllPlayers() {
        return ImmutableList.copyOf(this.connectionsByUuid.values());
    }

    @Override
    public int getPlayerCount() {
        return this.connectionsByUuid.size();
    }

    @Override
    public Optional<RegisteredServer> getServer(String name) {
        return this.servers.getServer(name);
    }

    @Override
    public Collection<RegisteredServer> getAllServers() {
        return this.servers.getAllServers();
    }

    @Override
    public RegisteredServer createRawRegisteredServer(ServerInfo server) {
        return this.servers.createRawRegisteredServer(server);
    }

    @Override
    public RegisteredServer registerServer(ServerInfo server) {
        return this.servers.register(server);
    }

    @Override
    public void unregisterServer(ServerInfo server) {
        this.servers.unregister(server);
    }

    @Override
    public VelocityConsole getConsoleCommandSource() {
        return this.console;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public VelocityEventManager getEventManager() {
        return this.eventManager;
    }

    @Override
    public VelocityScheduler getScheduler() {
        return this.scheduler;
    }

    @Override
    public VelocityChannelRegistrar getChannelRegistrar() {
        return this.channelRegistrar;
    }

    @Override
    public InetSocketAddress getBoundAddress() {
        if (this.configuration == null) {
            throw new IllegalStateException("No configuration");
        }
        return this.configuration.getBind();
    }

    @Override
    public @NonNull Iterable<? extends Audience> audiences() {
        ArrayList<CommandSource> audiences = new ArrayList<CommandSource>(this.getPlayerCount() + 1);
        audiences.add(this.console);
        audiences.addAll(this.getAllPlayers());
        return audiences;
    }

    public static Gson getPingGsonInstance(ProtocolVersion version) {
        if (version == ProtocolVersion.UNKNOWN || version.noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            return MODERN_PING_SERIALIZER;
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16)) {
            return PRE_1_20_3_PING_SERIALIZER;
        }
        return PRE_1_16_PING_SERIALIZER;
    }

    @Override
    public ResourcePackInfo.Builder createResourcePackBuilder(String url) {
        return new VelocityResourcePackInfo.BuilderImpl(url);
    }
}

