/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.velocitypowered.api.network.ProtocolState;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftConnectionAssociation;
import com.velocitypowered.proxy.connection.util.VelocityInboundConnection;
import com.velocitypowered.proxy.protocol.packet.DisconnectPacket;
import com.velocitypowered.proxy.protocol.packet.HandshakePacket;
import com.velocitypowered.proxy.util.ClosestLocaleMatcher;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.translation.GlobalTranslator;

public final class InitialInboundConnection
implements VelocityInboundConnection,
MinecraftConnectionAssociation {
    private static final ComponentLogger logger = ComponentLogger.logger(InitialInboundConnection.class);
    private final MinecraftConnection connection;
    private final String cleanedAddress;
    private final HandshakePacket handshake;

    InitialInboundConnection(MinecraftConnection connection, String cleanedAddress, HandshakePacket handshake) {
        this.connection = connection;
        this.cleanedAddress = cleanedAddress;
        this.handshake = handshake;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.connection.getRemoteAddress();
    }

    @Override
    public Optional<InetSocketAddress> getVirtualHost() {
        return Optional.of(InetSocketAddress.createUnresolved(this.cleanedAddress, this.handshake.getPort()));
    }

    @Override
    public Optional<String> getRawVirtualHost() {
        return Optional.of(this.handshake.getServerAddress());
    }

    @Override
    public boolean isActive() {
        return this.connection.getChannel().isActive();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.connection.getProtocolVersion();
    }

    public String toString() {
        boolean isPlayerAddressLoggingEnabled = this.connection.server.getConfiguration().isPlayerAddressLoggingEnabled();
        String playerIp = isPlayerAddressLoggingEnabled ? this.connection.getRemoteAddress().toString() : "<ip address withheld>";
        return "[initial connection] " + playerIp;
    }

    @Override
    public MinecraftConnection getConnection() {
        return this.connection;
    }

    @Override
    public ProtocolState getProtocolState() {
        return this.connection.getState().toProtocolState();
    }

    public void disconnect(Component reason) {
        Component translated = GlobalTranslator.render(reason, ClosestLocaleMatcher.INSTANCE.lookupClosest(Locale.getDefault()));
        if (this.connection.server.getConfiguration().isLogPlayerConnections()) {
            logger.info(Component.text(this + " has disconnected: ").append(translated));
        }
        this.connection.closeWith(DisconnectPacket.create(translated, this.getProtocolVersion(), this.connection.getState()));
    }

    public void disconnectQuietly(Component reason) {
        Component translated = GlobalTranslator.render(reason, ClosestLocaleMatcher.INSTANCE.lookupClosest(Locale.getDefault()));
        this.connection.closeWith(DisconnectPacket.create(translated, this.getProtocolVersion(), this.connection.getState()));
    }
}

