/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.protocol.packet.chat.RemoteChatSession;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.UUID;
import org.jetbrains.annotations.Nullable;

public class UpsertPlayerInfoPacket
implements MinecraftPacket {
    private final EnumSet<Action> actions;
    private final List<Entry> entries;

    public UpsertPlayerInfoPacket() {
        this.actions = EnumSet.noneOf(Action.class);
        this.entries = new ArrayList<Entry>();
    }

    public UpsertPlayerInfoPacket(Action action) {
        this.actions = EnumSet.of(action);
        this.entries = new ArrayList<Entry>();
    }

    public UpsertPlayerInfoPacket(EnumSet<Action> actions, List<Entry> entries) {
        this.actions = actions;
        this.entries = entries;
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public EnumSet<Action> getActions() {
        return this.actions;
    }

    public boolean containsAction(Action action) {
        return this.actions.contains((Object)action);
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    public void addAllActions(Collection<? extends Action> actions) {
        this.actions.addAll(actions);
    }

    public void addEntry(Entry entry) {
        this.entries.add(entry);
    }

    public void addAllEntries(Collection<? extends Entry> entries) {
        this.entries.addAll(entries);
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        Action[] actions = (Action[])Action.class.getEnumConstants();
        byte[] bytes = new byte[-Math.floorDiv(-actions.length, 8)];
        buf.readBytes(bytes);
        BitSet actionSet = BitSet.valueOf(bytes);
        for (int idx = 0; idx < actions.length; ++idx) {
            if (!actionSet.get(idx)) continue;
            this.addAction(actions[idx]);
        }
        int length = ProtocolUtils.readVarInt(buf);
        for (int idx = 0; idx < length; ++idx) {
            Entry entry = new Entry(ProtocolUtils.readUuid(buf));
            for (Action action : this.actions) {
                action.read.read(protocolVersion, buf, entry);
            }
            this.addEntry(entry);
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        Action[] actions = (Action[])Action.class.getEnumConstants();
        BitSet set = new BitSet(actions.length);
        for (int idx = 0; idx < actions.length; ++idx) {
            set.set(idx, this.actions.contains((Object)actions[idx]));
        }
        byte[] bytes = set.toByteArray();
        buf.writeBytes(Arrays.copyOf(bytes, -Math.floorDiv(-actions.length, 8)));
        ProtocolUtils.writeVarInt(buf, this.entries.size());
        for (Entry entry : this.entries) {
            ProtocolUtils.writeUuid(buf, entry.profileId);
            for (Action action : this.actions) {
                action.write.write(protocolVersion, buf, entry);
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public BitSet readFixedBitSet(ByteBuf buf, int param0) {
        byte[] var0 = new byte[-Math.floorDiv(-param0, 8)];
        buf.readBytes(var0);
        return BitSet.valueOf(var0);
    }

    public static enum Action {
        ADD_PLAYER((ignored, buf, info) -> {
            info.profile = new GameProfile(info.profileId, ProtocolUtils.readString(buf, 16), ProtocolUtils.readProperties(buf));
        }, (ignored, buf, info) -> {
            ProtocolUtils.writeString(buf, info.profile.getName());
            ProtocolUtils.writeProperties(buf, info.profile.getProperties());
        }),
        INITIALIZE_CHAT((version, buf, info) -> {
            info.chatSession = buf.readBoolean() ? new RemoteChatSession(version, buf) : null;
        }, (ignored, buf, info) -> {
            buf.writeBoolean(info.chatSession != null);
            if (info.chatSession != null) {
                info.chatSession.write(buf);
            }
        }),
        UPDATE_GAME_MODE((ignored, buf, info) -> {
            info.gameMode = ProtocolUtils.readVarInt(buf);
        }, (ignored, buf, info) -> ProtocolUtils.writeVarInt(buf, info.gameMode)),
        UPDATE_LISTED((ignored, buf, info) -> {
            info.listed = buf.readBoolean();
        }, (ignored, buf, info) -> buf.writeBoolean(info.listed)),
        UPDATE_LATENCY((ignored, buf, info) -> {
            info.latency = ProtocolUtils.readVarInt(buf);
        }, (ignored, buf, info) -> ProtocolUtils.writeVarInt(buf, info.latency)),
        UPDATE_DISPLAY_NAME((version, buf, info) -> {
            info.displayName = buf.readBoolean() ? ComponentHolder.read(buf, version) : null;
        }, (version, buf, info) -> {
            buf.writeBoolean(info.displayName != null);
            if (info.displayName != null) {
                info.displayName.write(buf);
            }
        }),
        UPDATE_LIST_ORDER((version, buf, info) -> {
            info.listOrder = ProtocolUtils.readVarInt(buf);
        }, (version, buf, info) -> ProtocolUtils.writeVarInt(buf, info.listOrder));

        private final Read read;
        private final Write write;

        private Action(Read read, Write write) {
            this.read = read;
            this.write = write;
        }

        private static interface Read {
            public void read(ProtocolVersion var1, ByteBuf var2, Entry var3);
        }

        private static interface Write {
            public void write(ProtocolVersion var1, ByteBuf var2, Entry var3);
        }
    }

    public static class Entry {
        private final UUID profileId;
        private GameProfile profile;
        private boolean listed;
        private int latency;
        private int gameMode;
        @Nullable
        private ComponentHolder displayName;
        private int listOrder;
        @Nullable
        private RemoteChatSession chatSession;

        public Entry(UUID uuid) {
            this.profileId = uuid;
        }

        public UUID getProfileId() {
            return this.profileId;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public boolean isListed() {
            return this.listed;
        }

        public int getLatency() {
            return this.latency;
        }

        public int getGameMode() {
            return this.gameMode;
        }

        @Nullable
        public ComponentHolder getDisplayName() {
            return this.displayName;
        }

        public int getListOrder() {
            return this.listOrder;
        }

        @Nullable
        public RemoteChatSession getChatSession() {
            return this.chatSession;
        }

        public void setProfile(GameProfile profile) {
            this.profile = profile;
        }

        public void setListed(boolean listed) {
            this.listed = listed;
        }

        public void setLatency(int latency) {
            this.latency = latency;
        }

        public void setGameMode(int gameMode) {
            this.gameMode = gameMode;
        }

        public void setDisplayName(@Nullable ComponentHolder displayName) {
            this.displayName = displayName;
        }

        public void setListOrder(int listOrder) {
            this.listOrder = listOrder;
        }

        public void setChatSession(@Nullable RemoteChatSession chatSession) {
            this.chatSession = chatSession;
        }

        public String toString() {
            return "Entry{profileId=" + this.profileId + ", profile=" + this.profile + ", listed=" + this.listed + ", latency=" + this.latency + ", gameMode=" + this.gameMode + ", displayName=" + this.displayName + ", listOrder=" + this.listOrder + ", chatSession=" + this.chatSession + "}";
        }
    }
}

