/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.chat.LastSeenMessages;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface CommandHandler<T extends MinecraftPacket> {
    public static final Logger logger = LogManager.getLogger(CommandHandler.class);

    public Class<T> packetClass();

    public void handlePlayerCommandInternal(T var1);

    default public boolean handlePlayerCommand(MinecraftPacket packet) {
        if (this.packetClass().isInstance(packet)) {
            this.handlePlayerCommandInternal((MinecraftPacket)this.packetClass().cast(packet));
            return true;
        }
        return false;
    }

    default public CompletableFuture<MinecraftPacket> runCommand(VelocityServer server, ConnectedPlayer player, String command, Function<Boolean, MinecraftPacket> hasRunPacketFunction) {
        return server.getCommandManager().executeImmediatelyAsync(player, command).thenApply(hasRunPacketFunction);
    }

    default public void queueCommandResult(VelocityServer server, ConnectedPlayer player, BiFunction<CommandExecuteEvent, LastSeenMessages, CompletableFuture<MinecraftPacket>> futurePacketCreator, String message, Instant timestamp, @Nullable LastSeenMessages lastSeenMessages) {
        CompletableFuture<CommandExecuteEvent> eventFuture = server.getCommandManager().callCommandEvent(player, message);
        player.getChatQueue().queuePacket(newLastSeenMessages -> ((CompletableFuture)((CompletableFuture)eventFuture.thenComposeAsync(event -> (CompletionStage)futurePacketCreator.apply((CommandExecuteEvent)event, (LastSeenMessages)newLastSeenMessages))).thenApply(pkt -> {
            if (server.getConfiguration().isLogCommandExecutions()) {
                logger.info("{} -> executed command /{}", (Object)player, (Object)message);
            }
            return pkt;
        })).exceptionally(e -> {
            logger.info("Exception occurred while running command for {}", (Object)player.getUsername(), e);
            player.sendMessage(Component.translatable("velocity.command.generic-error", (TextColor)NamedTextColor.RED));
            return null;
        }), timestamp, lastSeenMessages);
    }
}

