/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.Player;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public final class PlayerChatEvent
implements ResultedEvent<ChatResult> {
    private final Player player;
    private final String message;
    private ChatResult result;

    public PlayerChatEvent(Player player, String message) {
        this.player = Preconditions.checkNotNull(player, "player");
        this.message = Preconditions.checkNotNull(message, "message");
        this.result = ChatResult.allowed();
    }

    public Player getPlayer() {
        return this.player;
    }

    public String getMessage() {
        return this.message;
    }

    @Override
    public ChatResult getResult() {
        return this.result;
    }

    @Override
    @Deprecated
    public void setResult(ChatResult result) {
        this.result = Preconditions.checkNotNull(result, "result");
    }

    public String toString() {
        return "PlayerChatEvent{player=" + this.player + ", message=" + this.message + ", result=" + this.result + "}";
    }

    public static final class ChatResult
    implements ResultedEvent.Result {
        private static final ChatResult ALLOWED = new ChatResult(true, null);
        private static final ChatResult DENIED = new ChatResult(false, null);
        private @Nullable String message;
        private final boolean status;

        private ChatResult(boolean status, @Nullable String message) {
            this.status = status;
            this.message = message;
        }

        public Optional<String> getMessage() {
            return Optional.ofNullable(this.message);
        }

        @Override
        public boolean isAllowed() {
            return this.status;
        }

        public String toString() {
            return this.status ? "allowed" : "denied";
        }

        public static ChatResult allowed() {
            return ALLOWED;
        }

        public static ChatResult denied() {
            return DENIED;
        }

        public static ChatResult message(@NonNull String message) {
            Preconditions.checkNotNull(message, "message");
            return new ChatResult(true, message);
        }
    }
}

