/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.server;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.builder.AbstractBuilder;
import org.jetbrains.annotations.NotNull;

public final class PingOptions {
    public static final PingOptions DEFAULT = PingOptions.builder().build();
    private final ProtocolVersion protocolVersion;
    private final long timeout;

    private PingOptions(Builder builder) {
        this.protocolVersion = builder.protocolVersion;
        this.timeout = builder.timeout;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof PingOptions)) {
            return false;
        }
        PingOptions other = (PingOptions)o;
        return Objects.equals(this.protocolVersion, other.protocolVersion) && Objects.equals(this.timeout, other.timeout);
    }

    public int hashCode() {
        return Objects.hash(this.protocolVersion, this.timeout);
    }

    public String toString() {
        return "PingOptions{protocolVersion=" + this.protocolVersion + ", timeout=" + this.timeout + "}";
    }

    public static final class Builder
    implements AbstractBuilder<PingOptions> {
        private ProtocolVersion protocolVersion = ProtocolVersion.UNKNOWN;
        private long timeout = 0L;

        private Builder() {
        }

        public Builder version(@NotNull ProtocolVersion protocolVersion) {
            Preconditions.checkNotNull(protocolVersion, "protocolVersion cannot be null");
            this.protocolVersion = protocolVersion;
            return this;
        }

        public Builder timeout(@NotNull Duration timeout) {
            Preconditions.checkNotNull(timeout, "timeout cannot be null");
            this.timeout = timeout.toMillis();
            return this;
        }

        public Builder timeout(long time, @NotNull TimeUnit timeunit) {
            Preconditions.checkNotNull(timeunit, "timeunit cannot be null");
            this.timeout = timeunit.toMillis(time);
            return this;
        }

        @Override
        @NotNull
        public PingOptions build() {
            return new PingOptions(this);
        }
    }
}

