/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.server;

import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class ServerInfo
implements Comparable<ServerInfo> {
    private final String name;
    private final InetSocketAddress address;

    public ServerInfo(String name, InetSocketAddress address) {
        this.name = Preconditions.checkNotNull(name, "name");
        this.address = Preconditions.checkNotNull(address, "address");
    }

    public final String getName() {
        return this.name;
    }

    public final InetSocketAddress getAddress() {
        return this.address;
    }

    public String toString() {
        return "ServerInfo{name='" + this.name + "', address=" + this.address + "}";
    }

    public final boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServerInfo that = (ServerInfo)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.address, that.address);
    }

    public final int hashCode() {
        return Objects.hash(this.name, this.address);
    }

    @Override
    public int compareTo(ServerInfo o) {
        return this.name.compareTo(o.getName());
    }
}

