/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import com.velocitypowered.api.event.connection.DisconnectEvent;
import com.velocitypowered.api.event.connection.PreTransferEvent;
import com.velocitypowered.api.event.player.CookieRequestEvent;
import com.velocitypowered.api.event.player.CookieStoreEvent;
import com.velocitypowered.api.event.player.KickedFromServerEvent;
import com.velocitypowered.api.event.player.PlayerModInfoEvent;
import com.velocitypowered.api.event.player.PlayerSettingsChangedEvent;
import com.velocitypowered.api.event.player.ServerPreConnectEvent;
import com.velocitypowered.api.event.player.configuration.PlayerEnterConfigurationEvent;
import com.velocitypowered.api.network.ProtocolState;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.permission.PermissionFunction;
import com.velocitypowered.api.permission.PermissionProvider;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.ConnectionRequestBuilder;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.proxy.crypto.KeyIdentifiable;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.PluginMessageEncoder;
import com.velocitypowered.api.proxy.player.PlayerSettings;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.api.util.ModInfo;
import com.velocitypowered.api.util.ServerLink;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.adventure.VelocityBossBarImplementation;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftConnectionAssociation;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientConnectionPhase;
import com.velocitypowered.proxy.connection.client.ClientSettingsWrapper;
import com.velocitypowered.proxy.connection.player.bundle.BundleDelimiterHandler;
import com.velocitypowered.proxy.connection.player.resourcepack.VelocityResourcePackInfo;
import com.velocitypowered.proxy.connection.player.resourcepack.handler.ResourcePackHandler;
import com.velocitypowered.proxy.connection.util.ConnectionMessages;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.connection.util.VelocityInboundConnection;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.netty.MinecraftEncoder;
import com.velocitypowered.proxy.protocol.packet.BundleDelimiterPacket;
import com.velocitypowered.proxy.protocol.packet.ClientSettingsPacket;
import com.velocitypowered.proxy.protocol.packet.ClientboundCookieRequestPacket;
import com.velocitypowered.proxy.protocol.packet.ClientboundStoreCookiePacket;
import com.velocitypowered.proxy.protocol.packet.DisconnectPacket;
import com.velocitypowered.proxy.protocol.packet.HeaderAndFooterPacket;
import com.velocitypowered.proxy.protocol.packet.KeepAlivePacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.RemoveResourcePackPacket;
import com.velocitypowered.proxy.protocol.packet.TransferPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatQueue;
import com.velocitypowered.proxy.protocol.packet.chat.ChatType;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.protocol.packet.chat.PlayerChatCompletionPacket;
import com.velocitypowered.proxy.protocol.packet.chat.builder.ChatBuilderFactory;
import com.velocitypowered.proxy.protocol.packet.chat.builder.ChatBuilderV2;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatPacket;
import com.velocitypowered.proxy.protocol.packet.config.ClientboundServerLinksPacket;
import com.velocitypowered.proxy.protocol.packet.config.StartUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.title.GenericTitlePacket;
import com.velocitypowered.proxy.protocol.util.ByteBufDataOutput;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import com.velocitypowered.proxy.tablist.InternalTabList;
import com.velocitypowered.proxy.tablist.KeyedVelocityTabList;
import com.velocitypowered.proxy.tablist.VelocityTabList;
import com.velocitypowered.proxy.tablist.VelocityTabListLegacy;
import com.velocitypowered.proxy.util.ClosestLocaleMatcher;
import com.velocitypowered.proxy.util.DurationUtils;
import com.velocitypowered.proxy.util.TranslatableMapper;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.platform.facet.FacetPointers;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.resource.ResourcePackInfoLike;
import net.kyori.adventure.resource.ResourcePackRequest;
import net.kyori.adventure.resource.ResourcePackRequestLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import net.kyori.adventure.title.Title;
import net.kyori.adventure.title.TitlePart;
import net.kyori.adventure.translation.GlobalTranslator;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jetbrains.annotations.NotNull;

public class ConnectedPlayer
implements MinecraftConnectionAssociation,
Player,
KeyIdentifiable,
VelocityInboundConnection {
    private static final PlainTextComponentSerializer PASS_THRU_TRANSLATE = (PlainTextComponentSerializer)PlainTextComponentSerializer.builder().flattener(TranslatableMapper.FLATTENER).build();
    static final PermissionProvider DEFAULT_PERMISSIONS = s -> PermissionFunction.ALWAYS_UNDEFINED;
    private static final ComponentLogger logger = ComponentLogger.logger(ConnectedPlayer.class);
    private final Identity identity = new IdentityImpl();
    private final MinecraftConnection connection;
    private final @Nullable InetSocketAddress virtualHost;
    private final @Nullable String rawVirtualHost;
    private GameProfile profile;
    private PermissionFunction permissionFunction;
    private int tryIndex = 0;
    private long ping = -1L;
    private final boolean onlineMode;
    private @Nullable VelocityServerConnection connectedServer;
    private @Nullable VelocityServerConnection connectionInFlight;
    private @Nullable PlayerSettings settings;
    private @Nullable ModInfo modInfo;
    private final Set<VelocityBossBarImplementation> bossBars = new HashSet<VelocityBossBarImplementation>();
    private Component playerListHeader = Component.empty();
    private Component playerListFooter = Component.empty();
    private final InternalTabList tabList;
    private final VelocityServer server;
    private ClientConnectionPhase connectionPhase;
    private final CompletableFuture<Void> teardownFuture = new CompletableFuture();
    private @MonotonicNonNull List<String> serversToTry = null;
    private final ResourcePackHandler resourcePackHandler;
    private final BundleDelimiterHandler bundleHandler = new BundleDelimiterHandler(this);
    @NotNull
    private final Pointers pointers = (Pointers)((Pointers.Builder)Player.super.pointers().toBuilder()).withDynamic(Identity.UUID, this::getUniqueId).withDynamic(Identity.NAME, this::getUsername).withDynamic(Identity.DISPLAY_NAME, () -> Component.text(this.getUsername())).withDynamic(Identity.LOCALE, this::getEffectiveLocale).withStatic(PermissionChecker.POINTER, this.getPermissionChecker()).withStatic(FacetPointers.TYPE, FacetPointers.Type.PLAYER).build();
    private @Nullable String clientBrand;
    private @Nullable Locale effectiveLocale;
    private final @Nullable IdentifiedKey playerKey;
    private @Nullable ClientSettingsPacket clientSettingsPacket;
    private final ChatQueue chatQueue;
    private final ChatBuilderFactory chatBuilderFactory;

    ConnectedPlayer(VelocityServer server, GameProfile profile, MinecraftConnection connection, @Nullable InetSocketAddress virtualHost, @Nullable String rawVirtualHost, boolean onlineMode, @Nullable IdentifiedKey playerKey) {
        this.server = server;
        this.profile = profile;
        this.connection = connection;
        this.virtualHost = virtualHost;
        this.rawVirtualHost = rawVirtualHost;
        this.permissionFunction = PermissionFunction.ALWAYS_UNDEFINED;
        this.connectionPhase = connection.getType().getInitialClientPhase();
        this.onlineMode = onlineMode;
        this.tabList = connection.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_19_3) ? new VelocityTabList(this) : (connection.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8) ? new KeyedVelocityTabList(this, server) : new VelocityTabListLegacy(this, server));
        this.playerKey = playerKey;
        this.chatQueue = new ChatQueue(this);
        this.chatBuilderFactory = new ChatBuilderFactory(this.getProtocolVersion());
        this.resourcePackHandler = ResourcePackHandler.create(this, server);
    }

    public void disconnected() {
        for (VelocityBossBarImplementation bar : this.bossBars) {
            bar.viewerDisconnected(this);
        }
    }

    public ChatBuilderFactory getChatBuilderFactory() {
        return this.chatBuilderFactory;
    }

    public ChatQueue getChatQueue() {
        return this.chatQueue;
    }

    public BundleDelimiterHandler getBundleHandler() {
        return this.bundleHandler;
    }

    @Override
    public @NonNull Identity identity() {
        return this.identity;
    }

    @Override
    public String getUsername() {
        return this.profile.getName();
    }

    @Override
    public Locale getEffectiveLocale() {
        if (this.effectiveLocale == null && this.settings != null) {
            return this.settings.getLocale();
        }
        return this.effectiveLocale;
    }

    @Override
    public void setEffectiveLocale(@Nullable Locale locale) {
        this.effectiveLocale = locale;
    }

    @Override
    public UUID getUniqueId() {
        return this.profile.getId();
    }

    @Override
    public Optional<ServerConnection> getCurrentServer() {
        return Optional.ofNullable(this.connectedServer);
    }

    public VelocityServerConnection ensureAndGetCurrentServer() {
        VelocityServerConnection con = this.connectedServer;
        if (con == null) {
            throw new IllegalStateException("Not connected to server!");
        }
        return con;
    }

    @Override
    public GameProfile getGameProfile() {
        return this.profile;
    }

    @Override
    public MinecraftConnection getConnection() {
        return this.connection;
    }

    @Override
    public long getPing() {
        return this.ping;
    }

    void setPing(long ping) {
        this.ping = ping;
    }

    @Override
    public boolean isOnlineMode() {
        return this.onlineMode;
    }

    @Override
    public PlayerSettings getPlayerSettings() {
        return this.settings == null ? ClientSettingsWrapper.DEFAULT : this.settings;
    }

    public @Nullable ClientSettingsPacket getClientSettingsPacket() {
        return this.clientSettingsPacket;
    }

    @Override
    public boolean hasSentPlayerSettings() {
        return this.settings != null;
    }

    public void setClientSettings(ClientSettingsPacket clientSettingsPacket) {
        this.clientSettingsPacket = clientSettingsPacket;
        ClientSettingsWrapper cs = new ClientSettingsWrapper(clientSettingsPacket);
        this.settings = cs;
        this.server.getEventManager().fireAndForget(new PlayerSettingsChangedEvent(this, cs));
    }

    @Override
    public Optional<ModInfo> getModInfo() {
        return Optional.ofNullable(this.modInfo);
    }

    public void setModInfo(ModInfo modInfo) {
        this.modInfo = modInfo;
        this.server.getEventManager().fireAndForget(new PlayerModInfoEvent(this, modInfo));
    }

    @Override
    @NotNull
    public Pointers pointers() {
        return this.pointers;
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.connection.getRemoteAddress();
    }

    @Override
    public Optional<InetSocketAddress> getVirtualHost() {
        return Optional.ofNullable(this.virtualHost);
    }

    @Override
    public Optional<String> getRawVirtualHost() {
        return Optional.ofNullable(this.rawVirtualHost);
    }

    void setPermissionFunction(PermissionFunction permissionFunction) {
        this.permissionFunction = permissionFunction;
    }

    @Override
    public boolean isActive() {
        return this.connection.getChannel().isActive();
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.connection.getProtocolVersion();
    }

    public Component translateMessage(Component message) {
        Locale locale = ClosestLocaleMatcher.INSTANCE.lookupClosest(this.getEffectiveLocale() == null ? Locale.getDefault() : this.getEffectiveLocale());
        return GlobalTranslator.render(message, locale);
    }

    @Override
    public void sendMessage(@NonNull Identity identity, @NonNull Component message) {
        Component translated = this.translateMessage(message);
        this.connection.write(this.getChatBuilderFactory().builder().component(translated).forIdentity(identity).toClient());
    }

    @Override
    public void sendMessage(@NonNull Identity identity, @NonNull Component message, @NonNull MessageType type) {
        Preconditions.checkNotNull(message, "message");
        Preconditions.checkNotNull(type, "type");
        Component translated = this.translateMessage(message);
        this.connection.write(this.getChatBuilderFactory().builder().component(translated).forIdentity(identity).setType(type == MessageType.CHAT ? ChatType.CHAT : ChatType.SYSTEM).toClient());
    }

    @Override
    public void sendActionBar(@NonNull Component message) {
        Component translated = this.translateMessage(message);
        ProtocolVersion playerVersion = this.getProtocolVersion();
        if (playerVersion.noLessThan(ProtocolVersion.MINECRAFT_1_11)) {
            GenericTitlePacket pkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_ACTION_BAR, playerVersion);
            pkt.setComponent(new ComponentHolder(playerVersion, translated));
            this.connection.write(pkt);
        } else {
            JsonObject object = new JsonObject();
            object.addProperty("text", LegacyComponentSerializer.legacySection().serialize(translated));
            LegacyChatPacket legacyChat = new LegacyChatPacket();
            legacyChat.setMessage(object.toString());
            legacyChat.setType((byte)2);
            this.connection.write(legacyChat);
        }
    }

    @Override
    public Component getPlayerListHeader() {
        return this.playerListHeader;
    }

    @Override
    public Component getPlayerListFooter() {
        return this.playerListFooter;
    }

    @Override
    public void sendPlayerListHeader(@NonNull Component header) {
        this.sendPlayerListHeaderAndFooter(header, this.playerListFooter);
    }

    @Override
    public void sendPlayerListFooter(@NonNull Component footer) {
        this.sendPlayerListHeaderAndFooter(this.playerListHeader, footer);
    }

    @Override
    public void sendPlayerListHeaderAndFooter(@NotNull Component header, @NotNull Component footer) {
        Component translatedHeader = this.translateMessage(header);
        Component translatedFooter = this.translateMessage(footer);
        this.playerListHeader = translatedHeader;
        this.playerListFooter = translatedFooter;
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.connection.write(HeaderAndFooterPacket.create(translatedHeader, translatedFooter, this.getProtocolVersion()));
        }
    }

    @Override
    public void showTitle(@NonNull Title title) {
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            GenericTitlePacket timesPkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_TIMES, this.getProtocolVersion());
            Title.Times times = title.times();
            if (times != null) {
                timesPkt.setFadeIn((int)DurationUtils.toTicks(times.fadeIn()));
                timesPkt.setStay((int)DurationUtils.toTicks(times.stay()));
                timesPkt.setFadeOut((int)DurationUtils.toTicks(times.fadeOut()));
            }
            this.connection.delayedWrite(timesPkt);
            GenericTitlePacket subtitlePkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_SUBTITLE, this.getProtocolVersion());
            subtitlePkt.setComponent(new ComponentHolder(this.getProtocolVersion(), this.translateMessage(title.subtitle())));
            this.connection.delayedWrite(subtitlePkt);
            GenericTitlePacket titlePkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_TITLE, this.getProtocolVersion());
            titlePkt.setComponent(new ComponentHolder(this.getProtocolVersion(), this.translateMessage(title.title())));
            this.connection.delayedWrite(titlePkt);
            this.connection.flush();
        }
    }

    @Override
    public <T> void sendTitlePart(@NotNull TitlePart<T> part, @NotNull T value) {
        if (part == null) {
            throw new NullPointerException("part");
        }
        if (value == null) {
            throw new NullPointerException("value");
        }
        if (this.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_8)) {
            return;
        }
        if (part == TitlePart.TITLE) {
            GenericTitlePacket titlePkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_TITLE, this.getProtocolVersion());
            titlePkt.setComponent(new ComponentHolder(this.getProtocolVersion(), this.translateMessage((Component)value)));
            this.connection.write(titlePkt);
        } else if (part == TitlePart.SUBTITLE) {
            GenericTitlePacket titlePkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_SUBTITLE, this.getProtocolVersion());
            titlePkt.setComponent(new ComponentHolder(this.getProtocolVersion(), this.translateMessage((Component)value)));
            this.connection.write(titlePkt);
        } else if (part == TitlePart.TIMES) {
            Title.Times times = (Title.Times)value;
            GenericTitlePacket timesPkt = GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.SET_TIMES, this.getProtocolVersion());
            timesPkt.setFadeIn((int)DurationUtils.toTicks(times.fadeIn()));
            timesPkt.setStay((int)DurationUtils.toTicks(times.stay()));
            timesPkt.setFadeOut((int)DurationUtils.toTicks(times.fadeOut()));
            this.connection.write(timesPkt);
        } else {
            throw new IllegalArgumentException("Title part " + part + " is not valid");
        }
    }

    @Override
    public void clearTitle() {
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.connection.write(GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.HIDE, this.getProtocolVersion()));
        }
    }

    @Override
    public void resetTitle() {
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.connection.write(GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.RESET, this.getProtocolVersion()));
        }
    }

    @Override
    public void hideBossBar(@NonNull BossBar bar) {
        VelocityBossBarImplementation impl;
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_9) && (impl = VelocityBossBarImplementation.get(bar)).viewerRemove(this)) {
            this.bossBars.remove(impl);
        }
    }

    @Override
    public void showBossBar(@NonNull BossBar bar) {
        VelocityBossBarImplementation impl;
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_9) && (impl = VelocityBossBarImplementation.get(bar)).viewerAdd(this)) {
            this.bossBars.add(impl);
        }
    }

    @Override
    public ConnectionRequestBuilder createConnectionRequest(RegisteredServer server) {
        return new ConnectionRequestBuilderImpl(server, this.connectedServer);
    }

    private ConnectionRequestBuilder createConnectionRequest(RegisteredServer server, @Nullable VelocityServerConnection previousConnection) {
        return new ConnectionRequestBuilderImpl(server, previousConnection);
    }

    @Override
    public List<GameProfile.Property> getGameProfileProperties() {
        return this.profile.getProperties();
    }

    @Override
    public void setGameProfileProperties(List<GameProfile.Property> properties) {
        this.profile = this.profile.withProperties(Preconditions.checkNotNull(properties));
    }

    @Override
    public void clearPlayerListHeaderAndFooter() {
        this.clearPlayerListHeaderAndFooterSilent();
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.connection.write(HeaderAndFooterPacket.reset(this.getProtocolVersion()));
        }
    }

    public void clearPlayerListHeaderAndFooterSilent() {
        this.playerListHeader = Component.empty();
        this.playerListFooter = Component.empty();
    }

    @Override
    public InternalTabList getTabList() {
        return this.tabList;
    }

    @Override
    public void disconnect(Component reason) {
        if (this.connection.eventLoop().inEventLoop()) {
            this.disconnect0(reason, false);
        } else {
            this.connection.eventLoop().execute(() -> this.disconnect0(reason, false));
        }
    }

    public void disconnect0(Component reason, boolean duringLogin) {
        Component translated = this.translateMessage(reason);
        if (this.server.getConfiguration().isLogPlayerConnections()) {
            logger.info(Component.text(this + " has disconnected: ").append(translated));
        }
        this.connection.closeWith(DisconnectPacket.create(translated, this.getProtocolVersion(), this.connection.getState()));
    }

    public @Nullable VelocityServerConnection getConnectedServer() {
        return this.connectedServer;
    }

    public @Nullable VelocityServerConnection getConnectionInFlight() {
        return this.connectionInFlight;
    }

    public VelocityServerConnection getConnectionInFlightOrConnectedServer() {
        return this.connectionInFlight != null ? this.connectionInFlight : this.connectedServer;
    }

    public void resetInFlightConnection() {
        this.connectionInFlight = null;
    }

    public void handleConnectionException(RegisteredServer server, Throwable throwable, boolean safe) {
        TranslatableComponent friendlyError;
        Throwable cause;
        if (!this.isActive()) {
            return;
        }
        if (throwable == null) {
            throw new NullPointerException("throwable");
        }
        Throwable wrapped = throwable;
        if (throwable instanceof CompletionException && (cause = throwable.getCause()) != null) {
            wrapped = cause;
        }
        if (this.connectedServer != null && this.connectedServer.getServerInfo().equals(server.getServerInfo())) {
            friendlyError = Component.translatable("velocity.error.connected-server-error", Component.text(server.getServerInfo().getName()));
        } else {
            logger.error("{}: unable to connect to server {}", this, server.getServerInfo().getName(), wrapped);
            friendlyError = Component.translatable("velocity.error.connecting-server-error", Component.text(server.getServerInfo().getName()));
        }
        this.handleConnectionException(server, null, friendlyError.color(NamedTextColor.RED), safe);
    }

    public void handleConnectionException(RegisteredServer server, DisconnectPacket disconnect, boolean safe) {
        if (!this.isActive()) {
            return;
        }
        Component disconnectReason = disconnect.getReason().getComponent();
        String plainTextReason = PASS_THRU_TRANSLATE.serialize(disconnectReason);
        if (this.connectedServer != null && this.connectedServer.getServerInfo().equals(server.getServerInfo())) {
            logger.info("{}: kicked from server {}: {}", this, server.getServerInfo().getName(), plainTextReason);
            this.handleConnectionException(server, disconnectReason, Component.translatable("velocity.error.moved-to-new-server", (TextColor)NamedTextColor.RED, Component.text(server.getServerInfo().getName()), disconnectReason), safe);
        } else {
            logger.error("{}: disconnected while connecting to {}: {}", this, server.getServerInfo().getName(), plainTextReason);
            this.handleConnectionException(server, disconnectReason, Component.translatable("velocity.error.cant-connect", (TextColor)NamedTextColor.RED, Component.text(server.getServerInfo().getName()), disconnectReason), safe);
        }
    }

    private void handleConnectionException(RegisteredServer rs, @Nullable Component kickReason, Component friendlyReason, boolean safe) {
        KickedFromServerEvent.ServerKickResult result;
        boolean kickedFromCurrent;
        if (!this.isActive()) {
            return;
        }
        if (!safe) {
            this.disconnect(friendlyReason);
            return;
        }
        boolean bl = kickedFromCurrent = this.connectedServer == null || this.connectedServer.getServer().equals(rs);
        if (kickedFromCurrent) {
            Optional<RegisteredServer> next = this.getNextServerToTry(rs);
            result = next.map(KickedFromServerEvent.RedirectPlayer::create).orElseGet(() -> KickedFromServerEvent.DisconnectPlayer.create(friendlyReason));
        } else {
            if (this.connectionInFlight != null && this.connectionInFlight.getServer().equals(rs)) {
                this.resetInFlightConnection();
            }
            result = KickedFromServerEvent.Notify.create(friendlyReason);
        }
        KickedFromServerEvent originalEvent = new KickedFromServerEvent(this, rs, kickReason, !kickedFromCurrent, result);
        this.handleKickEvent(originalEvent, friendlyReason, kickedFromCurrent);
    }

    private void handleKickEvent(KickedFromServerEvent originalEvent, Component friendlyReason, boolean kickedFromCurrent) {
        this.server.getEventManager().fire(originalEvent).thenAcceptAsync(event -> {
            this.connectionInFlight = null;
            VelocityServerConnection previousConnection = this.connectedServer;
            if (kickedFromCurrent) {
                this.connectedServer = null;
            }
            if (!this.isActive()) {
                return;
            }
            KickedFromServerEvent.ServerKickResult patt30673$temp = event.getResult();
            if (patt30673$temp instanceof KickedFromServerEvent.DisconnectPlayer) {
                KickedFromServerEvent.DisconnectPlayer res = (KickedFromServerEvent.DisconnectPlayer)patt30673$temp;
                this.disconnect(res.getReasonComponent());
            } else {
                KickedFromServerEvent.ServerKickResult patt30795$temp = event.getResult();
                if (patt30795$temp instanceof KickedFromServerEvent.RedirectPlayer) {
                    KickedFromServerEvent.RedirectPlayer res = (KickedFromServerEvent.RedirectPlayer)patt30795$temp;
                    this.createConnectionRequest(res.getServer(), previousConnection).connect().whenCompleteAsync((status, throwable) -> {
                        if (throwable != null) {
                            this.handleConnectionException(status != null ? status.getAttemptedConnection() : res.getServer(), (Throwable)throwable, true);
                            return;
                        }
                        switch (status.getStatus()) {
                            case ALREADY_CONNECTED: {
                                logger.error("{}: already connected to {}", (Object)this, (Object)status.getAttemptedConnection().getServerInfo().getName());
                                break;
                            }
                            case CONNECTION_IN_PROGRESS: 
                            case CONNECTION_CANCELLED: {
                                Component fallbackMsg = res.getMessageComponent();
                                if (fallbackMsg == null) {
                                    fallbackMsg = friendlyReason;
                                }
                                this.disconnect(status.getReasonComponent().orElse(fallbackMsg));
                                break;
                            }
                            case SERVER_DISCONNECTED: {
                                Component reason = status.getReasonComponent().orElse(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
                                this.handleConnectionException(res.getServer(), DisconnectPacket.create(reason, this.getProtocolVersion(), this.connection.getState()), ((ConnectionRequestResults.Impl)status).isSafe());
                                break;
                            }
                            case SUCCESS: {
                                Component requestedMessage = res.getMessageComponent();
                                if (requestedMessage == null) {
                                    requestedMessage = friendlyReason;
                                }
                                if (requestedMessage == Component.empty()) break;
                                this.sendMessage(requestedMessage);
                                break;
                            }
                        }
                    }, (Executor)this.connection.eventLoop());
                } else {
                    KickedFromServerEvent.ServerKickResult patt32974$temp = event.getResult();
                    if (patt32974$temp instanceof KickedFromServerEvent.Notify) {
                        KickedFromServerEvent.Notify res = (KickedFromServerEvent.Notify)patt32974$temp;
                        if (event.kickedDuringServerConnect() && previousConnection != null) {
                            this.sendMessage(res.getMessageComponent());
                        } else {
                            this.disconnect(res.getMessageComponent());
                        }
                    } else {
                        this.disconnect(friendlyReason);
                    }
                }
            }
        }, (Executor)this.connection.eventLoop());
    }

    public Optional<RegisteredServer> getNextServerToTry() {
        return this.getNextServerToTry(null);
    }

    private Optional<RegisteredServer> getNextServerToTry(@Nullable RegisteredServer current) {
        if (this.serversToTry == null) {
            String virtualHostStr = this.getVirtualHost().map(InetSocketAddress::getHostString).orElse("").toLowerCase(Locale.ROOT);
            this.serversToTry = this.server.getConfiguration().getForcedHosts().getOrDefault(virtualHostStr, Collections.emptyList());
        }
        if (this.serversToTry.isEmpty()) {
            List<String> connOrder = this.server.getConfiguration().getAttemptConnectionOrder();
            if (connOrder.isEmpty()) {
                return Optional.empty();
            }
            this.serversToTry = connOrder;
        }
        for (int i = this.tryIndex; i < this.serversToTry.size(); ++i) {
            String toTryName = this.serversToTry.get(i);
            if (this.connectedServer != null && ConnectedPlayer.hasSameName(this.connectedServer.getServer(), toTryName) || this.connectionInFlight != null && ConnectedPlayer.hasSameName(this.connectionInFlight.getServer(), toTryName) || current != null && ConnectedPlayer.hasSameName(current, toTryName)) continue;
            this.tryIndex = i;
            return this.server.getServer(toTryName);
        }
        return Optional.empty();
    }

    private static boolean hasSameName(RegisteredServer server, String name) {
        return server.getServerInfo().getName().equalsIgnoreCase(name);
    }

    public void setConnectedServer(@Nullable VelocityServerConnection serverConnection) {
        this.connectedServer = serverConnection;
        this.tryIndex = 0;
        if (serverConnection == this.connectionInFlight) {
            this.connectionInFlight = null;
        }
    }

    public void sendLegacyForgeHandshakeResetPacket() {
        this.connectionPhase.resetConnectionPhase(this);
    }

    private MinecraftConnection ensureBackendConnection() {
        VelocityServerConnection sc = this.connectedServer;
        if (sc == null) {
            throw new IllegalStateException("No backend connection");
        }
        MinecraftConnection mc = sc.getConnection();
        if (mc == null) {
            throw new IllegalStateException("Backend connection is not connected to a server");
        }
        return mc;
    }

    void teardown() {
        if (this.connectionInFlight != null) {
            this.connectionInFlight.disconnect();
        }
        if (this.connectedServer != null) {
            this.connectedServer.disconnect();
        }
        Optional<Player> connectedPlayer = this.server.getPlayer(this.getUniqueId());
        this.server.unregisterConnection(this);
        DisconnectEvent.LoginStatus status = connectedPlayer.isPresent() ? (connectedPlayer.get().getCurrentServer().isEmpty() ? DisconnectEvent.LoginStatus.PRE_SERVER_JOIN : (connectedPlayer.get() == this ? DisconnectEvent.LoginStatus.SUCCESSFUL_LOGIN : DisconnectEvent.LoginStatus.CONFLICTING_LOGIN)) : (this.connection.isKnownDisconnect() ? DisconnectEvent.LoginStatus.CANCELLED_BY_PROXY : DisconnectEvent.LoginStatus.CANCELLED_BY_USER);
        DisconnectEvent event = new DisconnectEvent(this, status);
        this.server.getEventManager().fire(event).whenComplete((val, ex) -> {
            if (ex == null) {
                this.teardownFuture.complete(null);
            } else {
                this.teardownFuture.completeExceptionally((Throwable)ex);
            }
        });
    }

    public CompletableFuture<Void> getTeardownFuture() {
        return this.teardownFuture;
    }

    public String toString() {
        boolean isPlayerAddressLoggingEnabled = this.server.getConfiguration().isPlayerAddressLoggingEnabled();
        String playerIp = isPlayerAddressLoggingEnabled ? this.getRemoteAddress().toString() : "<ip address withheld>";
        return "[connected player] " + this.profile.getName() + " (" + playerIp + ")";
    }

    @Override
    public Tristate getPermissionValue(String permission) {
        return this.permissionFunction.getPermissionValue(permission);
    }

    @Override
    public boolean sendPluginMessage(@NotNull ChannelIdentifier identifier, byte @NotNull [] data) {
        Preconditions.checkNotNull(identifier, "identifier");
        Preconditions.checkNotNull(data, "data");
        PluginMessagePacket message = new PluginMessagePacket(identifier.getId(), Unpooled.wrappedBuffer(data));
        this.connection.write(message);
        return true;
    }

    @Override
    public boolean sendPluginMessage(@NotNull ChannelIdentifier identifier, @NotNull PluginMessageEncoder dataEncoder) {
        Objects.requireNonNull(identifier);
        Objects.requireNonNull(dataEncoder);
        ByteBuf buf = Unpooled.buffer();
        ByteBufDataOutput dataOutput = new ByteBufDataOutput(buf);
        dataEncoder.encode(dataOutput);
        if (buf.isReadable()) {
            PluginMessagePacket message = new PluginMessagePacket(identifier.getId(), buf);
            this.connection.write(message);
            return true;
        }
        buf.release();
        return false;
    }

    @Override
    public @Nullable String getClientBrand() {
        return this.clientBrand;
    }

    void setClientBrand(@Nullable String clientBrand) {
        this.clientBrand = clientBrand;
    }

    @Override
    public void transferToHost(InetSocketAddress address) {
        Preconditions.checkNotNull(address);
        Preconditions.checkArgument(this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_20_5) >= 0, "Player version must be 1.20.5 to be able to transfer to another host");
        this.server.getEventManager().fire(new PreTransferEvent(this, address)).thenAccept(event -> {
            if (event.getResult().isAllowed()) {
                InetSocketAddress resultedAddress = event.getResult().address();
                if (resultedAddress == null) {
                    resultedAddress = address;
                }
                this.connection.write(new TransferPacket(resultedAddress.getHostName(), resultedAddress.getPort()));
            }
        });
    }

    @Override
    public void storeCookie(Key key, byte[] data) {
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(data);
        Preconditions.checkArgument(this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_20_5), "Player version must be at least 1.20.5 to be able to store cookies");
        if (this.connection.getState() != StateRegistry.PLAY && this.connection.getState() != StateRegistry.CONFIG) {
            throw new IllegalStateException("Can only store cookie in CONFIGURATION or PLAY protocol");
        }
        this.server.getEventManager().fire(new CookieStoreEvent(this, key, data)).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                Key resultedKey = event.getResult().getKey() == null ? event.getOriginalKey() : event.getResult().getKey();
                byte[] resultedData = event.getResult().getData() == null ? event.getOriginalData() : event.getResult().getData();
                this.connection.write(new ClientboundStoreCookiePacket(resultedKey, resultedData));
            }
        }, (Executor)this.connection.eventLoop());
    }

    @Override
    public void requestCookie(Key key) {
        Preconditions.checkNotNull(key);
        Preconditions.checkArgument(this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_20_5), "Player version must be at least 1.20.5 to be able to retrieve cookies");
        this.server.getEventManager().fire(new CookieRequestEvent(this, key)).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                Key resultedKey = event.getResult().getKey() == null ? event.getOriginalKey() : event.getResult().getKey();
                this.connection.write(new ClientboundCookieRequestPacket(resultedKey));
            }
        }, (Executor)this.connection.eventLoop());
    }

    @Override
    public void setServerLinks(@NotNull List<ServerLink> links) {
        Preconditions.checkNotNull(links, "links");
        Preconditions.checkArgument(this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_21), "Player version must be at least 1.21 to be able to set server links");
        if (this.connection.getState() != StateRegistry.PLAY && this.connection.getState() != StateRegistry.CONFIG) {
            throw new IllegalStateException("Can only send server links in CONFIGURATION or PLAY protocol");
        }
        this.connection.write(new ClientboundServerLinksPacket(List.copyOf(links).stream().map(l -> new ClientboundServerLinksPacket.ServerLink((ServerLink)l, this.getProtocolVersion())).toList()));
    }

    @Override
    public void addCustomChatCompletions(@NotNull Collection<String> completions) {
        Preconditions.checkNotNull(completions, "completions");
        this.sendCustomChatCompletionPacket(completions, PlayerChatCompletionPacket.Action.ADD);
    }

    @Override
    public void removeCustomChatCompletions(@NotNull Collection<String> completions) {
        Preconditions.checkNotNull(completions, "completions");
        this.sendCustomChatCompletionPacket(completions, PlayerChatCompletionPacket.Action.REMOVE);
    }

    @Override
    public void setCustomChatCompletions(@NotNull Collection<String> completions) {
        Preconditions.checkNotNull(completions, "completions");
        this.sendCustomChatCompletionPacket(completions, PlayerChatCompletionPacket.Action.SET);
    }

    private void sendCustomChatCompletionPacket(@NotNull Collection<String> completions, PlayerChatCompletionPacket.Action action) {
        if (this.connection.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_19_1)) {
            this.connection.write(new PlayerChatCompletionPacket(completions.toArray(new String[0]), action));
        }
    }

    @Override
    public void spoofChatInput(String input) {
        Preconditions.checkArgument(input.length() <= 256, "input cannot be greater than 256 characters in length");
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            ChatBuilderV2 message = this.getChatBuilderFactory().builder().asPlayer(this).message(input);
            this.chatQueue.queuePacket(chatState -> {
                message.setTimestamp(chatState.lastTimestamp);
                message.setLastSeenMessages(chatState.createLastSeen());
                return message.toServer();
            });
        } else {
            this.ensureBackendConnection().write(this.getChatBuilderFactory().builder().asPlayer(this).message(input).toServer());
        }
    }

    public ResourcePackHandler resourcePackHandler() {
        return this.resourcePackHandler;
    }

    @Override
    @Deprecated
    public void sendResourcePack(String url) {
        this.sendResourcePackOffer(new VelocityResourcePackInfo.BuilderImpl(url).build());
    }

    @Override
    @Deprecated
    public void sendResourcePack(String url, byte[] hash) {
        this.sendResourcePackOffer(new VelocityResourcePackInfo.BuilderImpl(url).setHash(hash).build());
    }

    @Override
    public void sendResourcePackOffer(ResourcePackInfo packInfo) {
        this.resourcePackHandler.checkAlreadyAppliedPack(packInfo.getHash());
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            Preconditions.checkNotNull(packInfo, "packInfo");
            this.resourcePackHandler.queueResourcePack(packInfo);
        }
    }

    @Override
    public void sendResourcePacks(@NotNull ResourcePackRequest request) {
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            Preconditions.checkNotNull(request, "packRequest");
            this.resourcePackHandler.queueResourcePack(request);
        }
    }

    @Override
    public void clearResourcePacks() {
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            this.connection.write(new RemoveResourcePackPacket());
            this.resourcePackHandler.clearAppliedResourcePacks();
        }
    }

    @Override
    public void removeResourcePacks(@NotNull UUID id, UUID ... others) {
        if (this.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            Preconditions.checkNotNull(id, "packUUID");
            if (this.resourcePackHandler.remove(id)) {
                this.connection.write(new RemoveResourcePackPacket(id));
            }
            for (UUID other : others) {
                if (!this.resourcePackHandler.remove(other)) continue;
                this.connection.write(new RemoveResourcePackPacket(other));
            }
        }
    }

    @Override
    public void removeResourcePacks(@NotNull ResourcePackRequest request) {
        for (net.kyori.adventure.resource.ResourcePackInfo resourcePackInfo : request.packs()) {
            this.removeResourcePacks(resourcePackInfo.id(), new UUID[0]);
        }
    }

    @Override
    public void removeResourcePacks(@NotNull ResourcePackRequestLike request) {
        this.removeResourcePacks(request.asResourcePackRequest());
    }

    @Override
    public void removeResourcePacks(@NotNull ResourcePackInfoLike request, ResourcePackInfoLike ... others) {
        this.removeResourcePacks(request.asResourcePackInfo().id(), new UUID[0]);
        for (ResourcePackInfoLike other : others) {
            this.removeResourcePacks(other.asResourcePackInfo().id(), new UUID[0]);
        }
    }

    @Override
    @Deprecated
    public @Nullable ResourcePackInfo getAppliedResourcePack() {
        return this.resourcePackHandler.getFirstAppliedPack();
    }

    @Override
    @Deprecated
    public @Nullable ResourcePackInfo getPendingResourcePack() {
        return this.resourcePackHandler.getFirstPendingPack();
    }

    @Override
    @NotNull
    public Collection<ResourcePackInfo> getAppliedResourcePacks() {
        return this.resourcePackHandler.getAppliedResourcePacks();
    }

    @Override
    @NotNull
    public Collection<ResourcePackInfo> getPendingResourcePacks() {
        return this.resourcePackHandler.getPendingResourcePacks();
    }

    public void sendKeepAlive() {
        if (this.connection.getState() == StateRegistry.PLAY || this.connection.getState() == StateRegistry.CONFIG) {
            KeepAlivePacket keepAlive = new KeepAlivePacket();
            keepAlive.setRandomId(ThreadLocalRandom.current().nextLong());
            this.connection.write(keepAlive);
        }
    }

    public boolean forwardKeepAlive(KeepAlivePacket packet) {
        if (!this.sendKeepAliveToBackend(this.connectedServer, packet)) {
            return this.sendKeepAliveToBackend(this.connectionInFlight, packet);
        }
        return false;
    }

    private boolean sendKeepAliveToBackend(@Nullable VelocityServerConnection serverConnection, @NotNull KeepAlivePacket packet) {
        MinecraftConnection smc;
        Long sentTime;
        if (serverConnection != null && (sentTime = serverConnection.getPendingPings().remove(packet.getRandomId())) != null && (smc = serverConnection.getConnection()) != null) {
            this.setPing(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - sentTime));
            smc.write(packet);
            return true;
        }
        return false;
    }

    public void switchToConfigState() {
        ((CompletableFuture)this.server.getEventManager().fire(new PlayerEnterConfigurationEvent(this, this.getConnectionInFlightOrConnectedServer())).completeOnTimeout(null, 5L, TimeUnit.SECONDS).thenRunAsync(() -> {
            if (this.bundleHandler.isInBundleSession()) {
                this.bundleHandler.toggleBundleSession();
                this.connection.write(BundleDelimiterPacket.INSTANCE);
            }
            this.connection.write(StartUpdatePacket.INSTANCE);
            this.connection.getChannel().pipeline().get(MinecraftEncoder.class).setState(StateRegistry.CONFIG);
            this.connection.addPlayPacketQueueHandler();
        }, this.connection.eventLoop())).exceptionally(ex -> {
            logger.error("Error switching player connection to config state", (Throwable)ex);
            return null;
        });
    }

    public ClientConnectionPhase getPhase() {
        return this.connectionPhase;
    }

    public void setPhase(ClientConnectionPhase connectionPhase) {
        this.connectionPhase = connectionPhase;
    }

    @Override
    public @Nullable IdentifiedKey getIdentifiedKey() {
        return this.playerKey;
    }

    @Override
    public ProtocolState getProtocolState() {
        return this.connection.getState().toProtocolState();
    }

    private class IdentityImpl
    implements Identity {
        private IdentityImpl() {
        }

        @Override
        public @NonNull UUID uuid() {
            return ConnectedPlayer.this.getUniqueId();
        }
    }

    private final class ConnectionRequestBuilderImpl
    implements ConnectionRequestBuilder {
        private final RegisteredServer toConnect;
        private final @Nullable VelocityRegisteredServer previousServer;

        ConnectionRequestBuilderImpl(@Nullable RegisteredServer toConnect, VelocityServerConnection previousConnection) {
            this.toConnect = Preconditions.checkNotNull(toConnect, "info");
            this.previousServer = previousConnection == null ? null : previousConnection.getServer();
        }

        @Override
        public RegisteredServer getServer() {
            return this.toConnect;
        }

        private Optional<ConnectionRequestBuilder.Status> checkServer(RegisteredServer server) {
            Preconditions.checkArgument(server instanceof VelocityRegisteredServer, "Not a valid Velocity server.");
            if (ConnectedPlayer.this.connectionInFlight != null || ConnectedPlayer.this.connectedServer != null && !ConnectedPlayer.this.connectedServer.hasCompletedJoin()) {
                return Optional.of(ConnectionRequestBuilder.Status.CONNECTION_IN_PROGRESS);
            }
            if (ConnectedPlayer.this.connectedServer != null && ConnectedPlayer.this.connectedServer.getServer().getServerInfo().equals(server.getServerInfo())) {
                return Optional.of(ConnectionRequestBuilder.Status.ALREADY_CONNECTED);
            }
            return Optional.empty();
        }

        private CompletableFuture<Optional<ConnectionRequestBuilder.Status>> getInitialStatus() {
            return CompletableFuture.supplyAsync(() -> this.checkServer(this.toConnect), ConnectedPlayer.this.connection.eventLoop());
        }

        private CompletableFuture<ConnectionRequestResults.Impl> internalConnect() {
            return this.getInitialStatus().thenCompose(initialCheck -> {
                if (initialCheck.isPresent()) {
                    return CompletableFuture.completedFuture(ConnectionRequestResults.plainResult((ConnectionRequestBuilder.Status)((Object)((Object)initialCheck.get())), this.toConnect));
                }
                ServerPreConnectEvent event = new ServerPreConnectEvent(ConnectedPlayer.this, this.toConnect, this.previousServer);
                return ConnectedPlayer.this.server.getEventManager().fire(event).thenComposeAsync(newEvent -> {
                    VelocityServerConnection con;
                    Optional<RegisteredServer> newDest = newEvent.getResult().getServer();
                    if (newDest.isEmpty()) {
                        return CompletableFuture.completedFuture(ConnectionRequestResults.plainResult(ConnectionRequestBuilder.Status.CONNECTION_CANCELLED, this.toConnect));
                    }
                    RegisteredServer realDestination = newDest.get();
                    Optional<ConnectionRequestBuilder.Status> check = this.checkServer(realDestination);
                    if (check.isPresent()) {
                        return CompletableFuture.completedFuture(ConnectionRequestResults.plainResult(check.get(), realDestination));
                    }
                    VelocityRegisteredServer vrs = (VelocityRegisteredServer)realDestination;
                    ConnectedPlayer.this.connectionInFlight = con = new VelocityServerConnection(vrs, this.previousServer, ConnectedPlayer.this, ConnectedPlayer.this.server);
                    return con.connect().whenCompleteAsync((result, exception) -> this.resetIfInFlightIs(con), (Executor)ConnectedPlayer.this.connection.eventLoop());
                }, (Executor)ConnectedPlayer.this.connection.eventLoop());
            });
        }

        private void resetIfInFlightIs(VelocityServerConnection establishedConnection) {
            if (establishedConnection == ConnectedPlayer.this.connectionInFlight) {
                ConnectedPlayer.this.resetInFlightConnection();
            }
        }

        @Override
        public CompletableFuture<ConnectionRequestBuilder.Result> connect() {
            return ((CompletableFuture)this.internalConnect().whenCompleteAsync((status, throwable) -> {
                if (status != null && !status.isSuccessful() && !status.isSafe()) {
                    ConnectedPlayer.this.handleConnectionException(status.getAttemptedConnection(), (Throwable)throwable, false);
                }
            }, (Executor)ConnectedPlayer.this.connection.eventLoop())).thenApply(x -> x);
        }

        @Override
        public CompletableFuture<Boolean> connectWithIndication() {
            return ((CompletableFuture)this.internalConnect().whenCompleteAsync((status, throwable) -> {
                if (throwable != null) {
                    ConnectedPlayer.this.handleConnectionException(status != null ? status.getAttemptedConnection() : this.toConnect, (Throwable)throwable, true);
                    return;
                }
                switch (status.getStatus()) {
                    case ALREADY_CONNECTED: {
                        ConnectedPlayer.this.sendMessage(ConnectionMessages.ALREADY_CONNECTED);
                        break;
                    }
                    case CONNECTION_IN_PROGRESS: {
                        ConnectedPlayer.this.sendMessage(ConnectionMessages.IN_PROGRESS);
                        break;
                    }
                    case CONNECTION_CANCELLED: {
                        break;
                    }
                    case SERVER_DISCONNECTED: {
                        Component reason = status.getReasonComponent().orElse(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
                        ConnectedPlayer.this.handleConnectionException(this.toConnect, DisconnectPacket.create(reason, ConnectedPlayer.this.getProtocolVersion(), ConnectedPlayer.this.connection.getState()), status.isSafe());
                        break;
                    }
                }
            }, (Executor)ConnectedPlayer.this.connection.eventLoop())).thenApply(ConnectionRequestBuilder.Result::isSuccessful);
        }

        @Override
        public void fireAndForget() {
            this.connectWithIndication();
        }
    }
}

