/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.util.ByteProcessor;
import java.util.List;

public class MinecraftVarintFrameDecoder
extends ByteToMessageDecoder {
    private static final QuietDecoderException BAD_PACKET_LENGTH = new QuietDecoderException("Bad packet length");
    private static final QuietDecoderException VARINT_TOO_BIG = new QuietDecoderException("VarInt too big");

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        if (!ctx.channel().isActive()) {
            in.clear();
            return;
        }
        int packetStart = in.forEachByte(ByteProcessor.FIND_NON_NUL);
        if (packetStart == -1) {
            in.clear();
            return;
        }
        in.readerIndex(packetStart);
        in.markReaderIndex();
        int preIndex = in.readerIndex();
        int length = MinecraftVarintFrameDecoder.readRawVarInt21(in);
        if (preIndex == in.readerIndex()) {
            return;
        }
        if (length < 0) {
            throw BAD_PACKET_LENGTH;
        }
        if (length > 0) {
            if (in.readableBytes() < length) {
                in.resetReaderIndex();
            } else {
                out.add(in.readRetainedSlice(length));
            }
        }
    }

    private static int readRawVarInt21(ByteBuf buffer) {
        if (buffer.readableBytes() < 4) {
            return MinecraftVarintFrameDecoder.readRawVarintSmallBuf(buffer);
        }
        int wholeOrMore = buffer.getIntLE(buffer.readerIndex());
        int atStop = ~wholeOrMore & 0x808080;
        if (atStop == 0) {
            throw VARINT_TOO_BIG;
        }
        int bitsToKeep = Integer.numberOfTrailingZeros(atStop) + 1;
        buffer.skipBytes(bitsToKeep >> 3);
        int preservedBytes = wholeOrMore & (atStop ^ atStop - 1);
        preservedBytes = preservedBytes & 0x7F007F | (preservedBytes & 0x7F00) >> 1;
        preservedBytes = preservedBytes & 0x3FFF | (preservedBytes & 0x3FFF0000) >> 2;
        return preservedBytes;
    }

    private static int readRawVarintSmallBuf(ByteBuf buffer) {
        if (!buffer.isReadable()) {
            return 0;
        }
        buffer.markReaderIndex();
        byte tmp = buffer.readByte();
        if (tmp >= 0) {
            return tmp;
        }
        int result = tmp & 0x7F;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            return result | tmp << 7;
        }
        result |= (tmp & 0x7F) << 7;
        if (!buffer.isReadable()) {
            buffer.resetReaderIndex();
            return 0;
        }
        tmp = buffer.readByte();
        if (tmp >= 0) {
            return result | tmp << 14;
        }
        return result | (tmp & 0x7F) << 14;
    }
}

