/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.player.resourcepack.VelocityResourcePackInfo;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.UUID;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ResourcePackRequestPacket
implements MinecraftPacket {
    private @MonotonicNonNull UUID id;
    private @MonotonicNonNull String url;
    private @MonotonicNonNull String hash;
    private boolean isRequired;
    private @Nullable ComponentHolder prompt;
    private static final Pattern PLAUSIBLE_SHA1_HASH = Pattern.compile("^[a-z0-9]{40}$");

    public @Nullable UUID getId() {
        return this.id;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public @Nullable String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isRequired() {
        return this.isRequired;
    }

    public @Nullable String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public void setRequired(boolean required) {
        this.isRequired = required;
    }

    public @Nullable ComponentHolder getPrompt() {
        return this.prompt;
    }

    public void setPrompt(@Nullable ComponentHolder prompt) {
        this.prompt = prompt;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            this.id = ProtocolUtils.readUuid(buf);
        }
        this.url = ProtocolUtils.readString(buf);
        this.hash = ProtocolUtils.readString(buf);
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_17)) {
            this.isRequired = buf.readBoolean();
            this.prompt = buf.readBoolean() ? ComponentHolder.read(buf, protocolVersion) : null;
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
            if (this.id == null) {
                throw new IllegalStateException("Resource pack id not set yet!");
            }
            ProtocolUtils.writeUuid(buf, this.id);
        }
        if (this.url == null || this.hash == null) {
            throw new IllegalStateException("Packet not fully filled in yet!");
        }
        ProtocolUtils.writeString(buf, this.url);
        ProtocolUtils.writeString(buf, this.hash);
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_17)) {
            buf.writeBoolean(this.isRequired);
            if (this.prompt != null) {
                buf.writeBoolean(true);
                this.prompt.write(buf);
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    public VelocityResourcePackInfo toServerPromptedPack() {
        VelocityResourcePackInfo.BuilderImpl builder = new VelocityResourcePackInfo.BuilderImpl(Preconditions.checkNotNull(this.url)).setId(this.id).setPrompt(this.prompt == null ? null : this.prompt.getComponent()).setShouldForce(this.isRequired).setOrigin(ResourcePackInfo.Origin.DOWNSTREAM_SERVER);
        if (this.hash != null && !this.hash.isEmpty() && PLAUSIBLE_SHA1_HASH.matcher(this.hash).matches()) {
            builder.setHash(ByteBufUtil.decodeHexDump(this.hash));
        }
        return (VelocityResourcePackInfo)builder.build();
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public String toString() {
        return "ResourcePackRequestPacket{id=" + this.id + ", url='" + this.url + "', hash='" + this.hash + "', isRequired=" + this.isRequired + ", prompt=" + this.prompt + "}";
    }
}

