/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public class PlayerChooseInitialServerEvent {
    private final Player player;
    private @Nullable RegisteredServer initialServer;

    public PlayerChooseInitialServerEvent(Player player, @Nullable RegisteredServer initialServer) {
        this.player = Preconditions.checkNotNull(player, "player");
        this.initialServer = initialServer;
    }

    public Player getPlayer() {
        return this.player;
    }

    public Optional<RegisteredServer> getInitialServer() {
        return Optional.ofNullable(this.initialServer);
    }

    public void setInitialServer(@Nullable RegisteredServer server) {
        this.initialServer = server;
    }

    public String toString() {
        return "PlayerChooseInitialServerEvent{player=" + this.player + ", initialServer=" + this.initialServer + "}";
    }
}

