/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.ServerConnection;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.LegacyChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerInfo;
import com.velocitypowered.api.util.UuidUtils;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.util.ByteBufDataInput;
import com.velocitypowered.proxy.protocol.util.ByteBufDataOutput;
import com.velocitypowered.proxy.server.VelocityRegisteredServer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.StringJoiner;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.ComponentSerializer;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;

@SuppressFBWarnings(value={"OS_OPEN_STREAM"}, justification="Most methods in this class open instances of ByteBufDataOutput backed by heap-allocated ByteBufs. Closing them does nothing.")
public class BungeeCordMessageResponder {
    private static final MinecraftChannelIdentifier MODERN_CHANNEL = MinecraftChannelIdentifier.create("bungeecord", "main");
    private static final LegacyChannelIdentifier LEGACY_CHANNEL = new LegacyChannelIdentifier("BungeeCord");
    private final VelocityServer proxy;
    private final ConnectedPlayer player;

    BungeeCordMessageResponder(VelocityServer proxy, ConnectedPlayer player) {
        this.proxy = proxy;
        this.player = player;
    }

    public static boolean isBungeeCordMessage(PluginMessagePacket message) {
        return MODERN_CHANNEL.getId().equals(message.getChannel()) || LEGACY_CHANNEL.getId().equals(message.getChannel());
    }

    private void processConnect(ByteBufDataInput in) {
        String serverName = in.readUTF();
        this.proxy.getServer(serverName).ifPresent(server -> this.player.createConnectionRequest((RegisteredServer)server).fireAndForget());
    }

    private void processConnectOther(ByteBufDataInput in) {
        String playerName = in.readUTF();
        String serverName = in.readUTF();
        Optional<Player> referencedPlayer = this.proxy.getPlayer(playerName);
        Optional<RegisteredServer> referencedServer = this.proxy.getServer(serverName);
        if (referencedPlayer.isPresent() && referencedServer.isPresent()) {
            referencedPlayer.get().createConnectionRequest(referencedServer.get()).fireAndForget();
        }
    }

    private void processIp(ByteBufDataInput in) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufDataOutput out = new ByteBufDataOutput(buf);
        out.writeUTF("IP");
        out.writeUTF(this.player.getRemoteAddress().getHostString());
        out.writeInt(this.player.getRemoteAddress().getPort());
        this.sendResponseOnConnection(buf);
    }

    private void processPlayerCount(ByteBufDataInput in) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufDataOutput out = new ByteBufDataOutput(buf);
        String target = in.readUTF();
        if (target.equals("ALL")) {
            out.writeUTF("PlayerCount");
            out.writeUTF("ALL");
            out.writeInt(this.proxy.getPlayerCount());
        } else {
            this.proxy.getServer(target).ifPresent(rs -> {
                int playersOnServer = rs.getPlayersConnected().size();
                out.writeUTF("PlayerCount");
                out.writeUTF(rs.getServerInfo().getName());
                out.writeInt(playersOnServer);
            });
        }
        if (buf.isReadable()) {
            this.sendResponseOnConnection(buf);
        } else {
            buf.release();
        }
    }

    private void processPlayerList(ByteBufDataInput in) {
        ByteBuf buf = Unpooled.buffer();
        ByteBufDataOutput out = new ByteBufDataOutput(buf);
        String target = in.readUTF();
        if (target.equals("ALL")) {
            out.writeUTF("PlayerList");
            out.writeUTF("ALL");
            StringJoiner joiner = new StringJoiner(", ");
            for (Player online : this.proxy.getAllPlayers()) {
                joiner.add(online.getUsername());
            }
            out.writeUTF(joiner.toString());
        } else {
            this.proxy.getServer(target).ifPresent(info -> {
                out.writeUTF("PlayerList");
                out.writeUTF(info.getServerInfo().getName());
                StringJoiner joiner = new StringJoiner(", ");
                for (Player online : info.getPlayersConnected()) {
                    joiner.add(online.getUsername());
                }
                out.writeUTF(joiner.toString());
            });
        }
        if (buf.isReadable()) {
            this.sendResponseOnConnection(buf);
        } else {
            buf.release();
        }
    }

    private void processGetServers() {
        StringJoiner joiner = new StringJoiner(", ");
        for (RegisteredServer server : this.proxy.getAllServers()) {
            joiner.add(server.getServerInfo().getName());
        }
        ByteBuf buf = Unpooled.buffer();
        ByteBufDataOutput out = new ByteBufDataOutput(buf);
        out.writeUTF("GetServers");
        out.writeUTF(joiner.toString());
        this.sendResponseOnConnection(buf);
    }

    private void processMessage(ByteBufDataInput in) {
        this.processMessage0(in, LegacyComponentSerializer.legacySection());
    }

    private void processMessageRaw(ByteBufDataInput in) {
        this.processMessage0(in, GsonComponentSerializer.gson());
    }

    private void processMessage0(ByteBufDataInput in, ComponentSerializer<Component, ?, String> serializer) {
        String target = in.readUTF();
        String message = in.readUTF();
        Object messageComponent = serializer.deserialize(message);
        if (target.equals("ALL")) {
            this.proxy.sendMessage((Component)messageComponent);
        } else {
            this.proxy.getPlayer(target).ifPresent(player -> player.sendMessage((Component)messageComponent));
        }
    }

    private void processGetServer() {
        ByteBuf buf = Unpooled.buffer();
        ByteBufDataOutput out = new ByteBufDataOutput(buf);
        out.writeUTF("GetServer");
        out.writeUTF(this.player.ensureAndGetCurrentServer().getServerInfo().getName());
        this.sendResponseOnConnection(buf);
    }

    private void processUuid() {
        ByteBuf buf = Unpooled.buffer();
        ByteBufDataOutput out = new ByteBufDataOutput(buf);
        out.writeUTF("UUID");
        out.writeUTF(UuidUtils.toUndashed(this.player.getUniqueId()));
        this.sendResponseOnConnection(buf);
    }

    private void processUuidOther(ByteBufDataInput in) {
        this.proxy.getPlayer(in.readUTF()).ifPresent(player -> {
            ByteBuf buf = Unpooled.buffer();
            ByteBufDataOutput out = new ByteBufDataOutput(buf);
            out.writeUTF("UUIDOther");
            out.writeUTF(player.getUsername());
            out.writeUTF(UuidUtils.toUndashed(player.getUniqueId()));
            this.sendResponseOnConnection(buf);
        });
    }

    private void processIpOther(ByteBufDataInput in) {
        this.proxy.getPlayer(in.readUTF()).ifPresent(player -> {
            ByteBuf buf = Unpooled.buffer();
            ByteBufDataOutput out = new ByteBufDataOutput(buf);
            out.writeUTF("IPOther");
            out.writeUTF(player.getUsername());
            out.writeUTF(player.getRemoteAddress().getHostString());
            out.writeInt(player.getRemoteAddress().getPort());
            this.sendResponseOnConnection(buf);
        });
    }

    private void processServerIp(ByteBufDataInput in) {
        this.proxy.getServer(in.readUTF()).ifPresent(info -> {
            ByteBuf buf = Unpooled.buffer();
            ByteBufDataOutput out = new ByteBufDataOutput(buf);
            out.writeUTF("ServerIP");
            out.writeUTF(info.getServerInfo().getName());
            out.writeUTF(info.getServerInfo().getAddress().getHostString());
            out.writeShort(info.getServerInfo().getAddress().getPort());
            this.sendResponseOnConnection(buf);
        });
    }

    private void processKick(ByteBufDataInput in) {
        this.proxy.getPlayer(in.readUTF()).ifPresent(player -> {
            String kickReason = in.readUTF();
            player.disconnect(LegacyComponentSerializer.legacySection().deserialize(kickReason));
        });
    }

    private void processKickRaw(ByteBufDataInput in) {
        this.proxy.getPlayer(in.readUTF()).ifPresent(player -> {
            String kickReason = in.readUTF();
            player.disconnect((Component)GsonComponentSerializer.gson().deserialize(kickReason));
        });
    }

    private void processForwardToPlayer(ByteBufDataInput in) {
        Optional<Player> player = this.proxy.getPlayer(in.readUTF());
        if (player.isPresent()) {
            ByteBuf toForward = in.unwrap().copy();
            BungeeCordMessageResponder.sendServerResponse((ConnectedPlayer)player.get(), toForward);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processForwardToServer(ByteBufDataInput in) {
        String target = in.readUTF();
        ByteBuf toForward = in.unwrap().copy();
        ServerInfo currentUserServer = this.player.getCurrentServer().map(ServerConnection::getServerInfo).orElse(null);
        if (target.equals("ALL") || target.equals("ONLINE")) {
            try {
                for (RegisteredServer rs : this.proxy.getAllServers()) {
                    if (rs.getServerInfo().equals(currentUserServer)) continue;
                    ((VelocityRegisteredServer)rs).sendPluginMessage((ChannelIdentifier)LEGACY_CHANNEL, toForward.retainedSlice());
                }
            }
            finally {
                toForward.release();
            }
        } else {
            Optional<RegisteredServer> server = this.proxy.getServer(target);
            if (server.isPresent()) {
                ((VelocityRegisteredServer)server.get()).sendPluginMessage((ChannelIdentifier)LEGACY_CHANNEL, toForward);
            } else {
                toForward.release();
            }
        }
    }

    private void processGetPlayerServer(ByteBufDataInput in) {
        this.proxy.getPlayer(in.readUTF()).ifPresent(player -> player.getCurrentServer().ifPresent(server -> {
            ByteBuf buf = Unpooled.buffer();
            ByteBufDataOutput out = new ByteBufDataOutput(buf);
            out.writeUTF("GetPlayerServer");
            out.writeUTF(player.getUsername());
            out.writeUTF(server.getServerInfo().getName());
            this.sendResponseOnConnection(buf);
        }));
    }

    static String getBungeeCordChannel(ProtocolVersion version) {
        return version.noLessThan(ProtocolVersion.MINECRAFT_1_13) ? MODERN_CHANNEL.getId() : LEGACY_CHANNEL.getId();
    }

    private void sendResponseOnConnection(ByteBuf buf) {
        BungeeCordMessageResponder.sendServerResponse(this.player, buf);
    }

    private static void sendServerResponse(ConnectedPlayer player, ByteBuf buf) {
        MinecraftConnection serverConnection = player.ensureAndGetCurrentServer().ensureConnected();
        String chan = BungeeCordMessageResponder.getBungeeCordChannel(serverConnection.getProtocolVersion());
        PluginMessagePacket msg = new PluginMessagePacket(chan, buf);
        serverConnection.write(msg);
    }

    boolean process(PluginMessagePacket message) {
        String subChannel;
        if (!this.proxy.getConfiguration().isBungeePluginChannelEnabled()) {
            return false;
        }
        if (!BungeeCordMessageResponder.isBungeeCordMessage(message)) {
            return false;
        }
        ByteBufDataInput in = new ByteBufDataInput(message.content());
        switch (subChannel = in.readUTF()) {
            case "GetPlayerServer": {
                this.processGetPlayerServer(in);
                break;
            }
            case "ForwardToPlayer": {
                this.processForwardToPlayer(in);
                break;
            }
            case "Forward": {
                this.processForwardToServer(in);
                break;
            }
            case "Connect": {
                this.processConnect(in);
                break;
            }
            case "ConnectOther": {
                this.processConnectOther(in);
                break;
            }
            case "IP": {
                this.processIp(in);
                break;
            }
            case "PlayerCount": {
                this.processPlayerCount(in);
                break;
            }
            case "PlayerList": {
                this.processPlayerList(in);
                break;
            }
            case "GetServers": {
                this.processGetServers();
                break;
            }
            case "Message": {
                this.processMessage(in);
                break;
            }
            case "MessageRaw": {
                this.processMessageRaw(in);
                break;
            }
            case "GetServer": {
                this.processGetServer();
                break;
            }
            case "UUID": {
                this.processUuid();
                break;
            }
            case "UUIDOther": {
                this.processUuidOther(in);
                break;
            }
            case "IPOther": {
                this.processIpOther(in);
                break;
            }
            case "ServerIP": {
                this.processServerIp(in);
                break;
            }
            case "KickPlayer": {
                this.processKick(in);
                break;
            }
            case "KickPlayerRaw": {
                this.processKickRaw(in);
                break;
            }
        }
        return true;
    }
}

