/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.CookieReceiveEvent;
import com.velocitypowered.api.event.player.PlayerClientBrandEvent;
import com.velocitypowered.api.event.player.configuration.PlayerConfigurationEvent;
import com.velocitypowered.api.event.player.configuration.PlayerFinishConfigurationEvent;
import com.velocitypowered.api.event.player.configuration.PlayerFinishedConfigurationEvent;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BungeeCordMessageResponder;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.player.resourcepack.ResourcePackResponseBundle;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.netty.MinecraftEncoder;
import com.velocitypowered.proxy.protocol.packet.ClientSettingsPacket;
import com.velocitypowered.proxy.protocol.packet.KeepAlivePacket;
import com.velocitypowered.proxy.protocol.packet.PingIdentifyPacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponsePacket;
import com.velocitypowered.proxy.protocol.packet.ServerboundCookieResponsePacket;
import com.velocitypowered.proxy.protocol.packet.config.FinishedUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.config.KnownPacksPacket;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientConfigSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(ClientConfigSessionHandler.class);
    private final VelocityServer server;
    private final ConnectedPlayer player;
    private String brandChannel = null;
    private CompletableFuture<?> configurationFuture;
    private CompletableFuture<Void> configSwitchFuture;

    public ClientConfigSessionHandler(VelocityServer server, ConnectedPlayer player) {
        this.server = server;
        this.player = player;
    }

    @Override
    public void activated() {
        this.configSwitchFuture = new CompletableFuture();
    }

    @Override
    public void deactivated() {
        this.configurationFuture = null;
    }

    @Override
    public boolean handle(KeepAlivePacket packet) {
        this.player.forwardKeepAlive(packet);
        return true;
    }

    @Override
    public boolean handle(ClientSettingsPacket packet) {
        this.player.setClientSettings(packet);
        return true;
    }

    @Override
    public boolean handle(ResourcePackResponsePacket packet) {
        return this.player.resourcePackHandler().onResourcePackResponse(new ResourcePackResponseBundle(packet.getId(), packet.getHash(), packet.getStatus()));
    }

    @Override
    public boolean handle(FinishedUpdatePacket packet) {
        this.player.getConnection().setActiveSessionHandler(StateRegistry.PLAY, new ClientPlaySessionHandler(this.server, this.player));
        this.configSwitchFuture.complete(null);
        return true;
    }

    @Override
    public boolean handle(PluginMessagePacket packet) {
        VelocityServerConnection serverConn = this.player.getConnectionInFlight();
        if (PluginMessageUtil.isMcBrand(packet)) {
            String brand = PluginMessageUtil.readBrandMessage(packet.content());
            this.server.getEventManager().fireAndForget(new PlayerClientBrandEvent(this.player, brand));
            this.player.setClientBrand(brand);
            this.brandChannel = packet.getChannel();
        } else {
            if (BungeeCordMessageResponder.isBungeeCordMessage(packet)) {
                return true;
            }
            if (serverConn != null) {
                byte[] bytes = ByteBufUtil.getBytes(packet.content());
                ChannelIdentifier id = this.server.getChannelRegistrar().getFromId(packet.getChannel());
                if (id == null) {
                    serverConn.ensureConnected().write(packet.retain());
                    return true;
                }
                serverConn.getPlayer().getConnection().setAutoReading(false);
                ((CompletableFuture)this.server.getEventManager().fire(new PluginMessageEvent(serverConn.getPlayer(), serverConn, id, bytes)).thenAcceptAsync(pme -> {
                    if (pme.getResult().isAllowed() && serverConn.getConnection() != null) {
                        serverConn.ensureConnected().write(new PluginMessagePacket(pme.getIdentifier().getId(), Unpooled.wrappedBuffer(bytes)));
                    }
                    serverConn.getPlayer().getConnection().setAutoReading(true);
                }, (Executor)this.player.getConnection().eventLoop())).exceptionally(ex -> {
                    logger.error("Exception while handling plugin message packet for {}", (Object)this.player, ex);
                    return null;
                });
            }
        }
        return true;
    }

    @Override
    public boolean handle(PingIdentifyPacket packet) {
        if (this.player.getConnectionInFlight() != null) {
            this.player.getConnectionInFlight().ensureConnected().write(packet);
            return true;
        }
        return false;
    }

    @Override
    public boolean handle(KnownPacksPacket packet) {
        ((CompletableFuture)this.callConfigurationEvent().thenRun(() -> this.player.getConnectionInFlightOrConnectedServer().ensureConnected().write(packet))).exceptionally(ex -> {
            logger.error("Error forwarding known packs response to backend:", (Throwable)ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(ServerboundCookieResponsePacket packet) {
        this.server.getEventManager().fire(new CookieReceiveEvent(this.player, packet.getKey(), packet.getPayload())).thenAcceptAsync(event -> {
            VelocityServerConnection serverConnection;
            if (event.getResult().isAllowed() && (serverConnection = this.player.getConnectionInFlight()) != null) {
                Key resultedKey = event.getResult().getKey() == null ? event.getOriginalKey() : event.getResult().getKey();
                byte[] resultedData = event.getResult().getData() == null ? event.getOriginalData() : event.getResult().getData();
                serverConnection.ensureConnected().write(new ServerboundCookieResponsePacket(resultedKey, resultedData));
            }
        }, (Executor)this.player.getConnection().eventLoop());
        return true;
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return;
        }
        MinecraftConnection smc = serverConnection.getConnection();
        if (smc != null && serverConnection.getPhase().consideredComplete()) {
            if (packet instanceof PluginMessagePacket) {
                ((PluginMessagePacket)packet).retain();
            }
            smc.write(packet);
        }
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return;
        }
        MinecraftConnection smc = serverConnection.getConnection();
        if (smc != null && !smc.isClosed() && serverConnection.getPhase().consideredComplete()) {
            smc.write(buf.retain());
        }
    }

    @Override
    public void disconnected() {
        this.player.teardown();
    }

    @Override
    public void exception(Throwable throwable) {
        this.player.disconnect(Component.translatable("velocity.error.player-connection-error", (TextColor)NamedTextColor.RED));
    }

    private CompletableFuture<?> callConfigurationEvent() {
        if (this.configurationFuture != null) {
            return this.configurationFuture;
        }
        this.configurationFuture = this.server.getEventManager().fire(new PlayerConfigurationEvent(this.player, this.player.getConnectionInFlightOrConnectedServer()));
        return this.configurationFuture;
    }

    public CompletableFuture<Void> handleBackendFinishUpdate(VelocityServerConnection serverConn) {
        MinecraftConnection smc = serverConn.ensureConnected();
        String brand = serverConn.getPlayer().getClientBrand();
        if (brand != null && this.brandChannel != null) {
            ByteBuf buf = Unpooled.buffer();
            ProtocolUtils.writeString(buf, brand);
            PluginMessagePacket brandPacket = new PluginMessagePacket(this.brandChannel, buf);
            smc.write(brandPacket);
        }
        ((CompletableFuture)((CompletableFuture)this.callConfigurationEvent().thenCompose(v -> this.server.getEventManager().fire(new PlayerFinishConfigurationEvent(this.player, serverConn)).completeOnTimeout(null, 5L, TimeUnit.SECONDS))).thenRunAsync(() -> {
            this.player.getConnection().write(FinishedUpdatePacket.INSTANCE);
            this.player.getConnection().getChannel().pipeline().get(MinecraftEncoder.class).setState(StateRegistry.PLAY);
            this.server.getEventManager().fireAndForget(new PlayerFinishedConfigurationEvent(this.player, serverConn));
        }, this.player.getConnection().eventLoop())).exceptionally(ex -> {
            logger.error("Error finishing configuration state:", (Throwable)ex);
            return null;
        });
        return this.configSwitchFuture;
    }
}

