/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.registry.DimensionInfo;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.JoinGamePacket;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.checkerframework.checker.nullness.qual.Nullable;

public class RespawnPacket
implements MinecraftPacket {
    private int dimension;
    private long partialHashedSeed;
    private short difficulty;
    private short gamemode;
    private String levelType = "";
    private byte dataToKeep;
    private DimensionInfo dimensionInfo;
    private short previousGamemode;
    private CompoundBinaryTag currentDimensionData;
    private @Nullable Pair<String, Long> lastDeathPosition;
    private int portalCooldown;
    private int seaLevel;

    public RespawnPacket() {
    }

    public RespawnPacket(int dimension, long partialHashedSeed, short difficulty, short gamemode, String levelType, byte dataToKeep, DimensionInfo dimensionInfo, short previousGamemode, CompoundBinaryTag currentDimensionData, @Nullable Pair<String, Long> lastDeathPosition, int portalCooldown, int seaLevel) {
        this.dimension = dimension;
        this.partialHashedSeed = partialHashedSeed;
        this.difficulty = difficulty;
        this.gamemode = gamemode;
        this.levelType = levelType;
        this.dataToKeep = dataToKeep;
        this.dimensionInfo = dimensionInfo;
        this.previousGamemode = previousGamemode;
        this.currentDimensionData = currentDimensionData;
        this.lastDeathPosition = lastDeathPosition;
        this.portalCooldown = portalCooldown;
        this.seaLevel = seaLevel;
    }

    public static RespawnPacket fromJoinGame(JoinGamePacket joinGame) {
        return new RespawnPacket(joinGame.getDimension(), joinGame.getPartialHashedSeed(), joinGame.getDifficulty(), joinGame.getGamemode(), joinGame.getLevelType(), 0, joinGame.getDimensionInfo(), joinGame.getPreviousGamemode(), joinGame.getCurrentDimensionData(), joinGame.getLastDeathPosition(), joinGame.getPortalCooldown(), joinGame.getSeaLevel());
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public long getPartialHashedSeed() {
        return this.partialHashedSeed;
    }

    public void setPartialHashedSeed(long partialHashedSeed) {
        this.partialHashedSeed = partialHashedSeed;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public short getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(short gamemode) {
        this.gamemode = gamemode;
    }

    public String getLevelType() {
        return this.levelType;
    }

    public void setLevelType(String levelType) {
        this.levelType = levelType;
    }

    public byte getDataToKeep() {
        return this.dataToKeep;
    }

    public void setDataToKeep(byte dataToKeep) {
        this.dataToKeep = dataToKeep;
    }

    public short getPreviousGamemode() {
        return this.previousGamemode;
    }

    public void setPreviousGamemode(short previousGamemode) {
        this.previousGamemode = previousGamemode;
    }

    public Pair<String, Long> getLastDeathPosition() {
        return this.lastDeathPosition;
    }

    public void setLastDeathPosition(Pair<String, Long> lastDeathPosition) {
        this.lastDeathPosition = lastDeathPosition;
    }

    public int getPortalCooldown() {
        return this.portalCooldown;
    }

    public void setPortalCooldown(int portalCooldown) {
        this.portalCooldown = portalCooldown;
    }

    public int getSeaLevel() {
        return this.seaLevel;
    }

    public void setSeaLevel(int seaLevel) {
        this.seaLevel = seaLevel;
    }

    public String toString() {
        return "Respawn{dimension=" + this.dimension + ", partialHashedSeed=" + this.partialHashedSeed + ", difficulty=" + this.difficulty + ", gamemode=" + this.gamemode + ", levelType='" + this.levelType + "', dataToKeep=" + this.dataToKeep + ", dimensionRegistryName='" + this.dimensionInfo.toString() + "', dimensionInfo=" + this.dimensionInfo + ", previousGamemode=" + this.previousGamemode + ", dimensionData=" + this.currentDimensionData + ", portalCooldown=" + this.portalCooldown + ", seaLevel=" + this.seaLevel + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        String dimensionKey = "";
        String levelName = null;
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16)) {
            if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16_2) && version.lessThan(ProtocolVersion.MINECRAFT_1_19)) {
                this.currentDimensionData = ProtocolUtils.readCompoundTag(buf, version, BinaryTagIO.reader());
                dimensionKey = ProtocolUtils.readString(buf);
            } else {
                if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
                    this.dimension = ProtocolUtils.readVarInt(buf);
                } else {
                    dimensionKey = ProtocolUtils.readString(buf);
                }
                levelName = ProtocolUtils.readString(buf);
            }
        } else {
            this.dimension = buf.readInt();
        }
        if (version.noGreaterThan(ProtocolVersion.MINECRAFT_1_13_2)) {
            this.difficulty = buf.readUnsignedByte();
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_15)) {
            this.partialHashedSeed = buf.readLong();
        }
        this.gamemode = buf.readByte();
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16)) {
            this.previousGamemode = buf.readByte();
            boolean isDebug = buf.readBoolean();
            boolean isFlat = buf.readBoolean();
            this.dimensionInfo = new DimensionInfo(dimensionKey, levelName, isFlat, isDebug, version);
            if (version.lessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
                this.dataToKeep = (byte)(buf.readBoolean() ? 1 : 0);
            } else if (version.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                this.dataToKeep = buf.readByte();
            }
        } else {
            this.levelType = ProtocolUtils.readString(buf, 16);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19) && buf.readBoolean()) {
            this.lastDeathPosition = Pair.of(ProtocolUtils.readString(buf), buf.readLong());
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20)) {
            this.portalCooldown = ProtocolUtils.readVarInt(buf);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_21_2)) {
            this.seaLevel = ProtocolUtils.readVarInt(buf);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            this.dataToKeep = buf.readByte();
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16)) {
            if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16_2) && version.lessThan(ProtocolVersion.MINECRAFT_1_19)) {
                ProtocolUtils.writeBinaryTag(buf, version, this.currentDimensionData);
                ProtocolUtils.writeString(buf, this.dimensionInfo.getRegistryIdentifier());
            } else {
                if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_5)) {
                    ProtocolUtils.writeVarInt(buf, this.dimension);
                } else {
                    ProtocolUtils.writeString(buf, this.dimensionInfo.getRegistryIdentifier());
                }
                ProtocolUtils.writeString(buf, this.dimensionInfo.getLevelName());
            }
        } else {
            buf.writeInt(this.dimension);
        }
        if (version.noGreaterThan(ProtocolVersion.MINECRAFT_1_13_2)) {
            buf.writeByte(this.difficulty);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_15)) {
            buf.writeLong(this.partialHashedSeed);
        }
        buf.writeByte(this.gamemode);
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_16)) {
            buf.writeByte(this.previousGamemode);
            buf.writeBoolean(this.dimensionInfo.isDebugType());
            buf.writeBoolean(this.dimensionInfo.isFlat());
            if (version.lessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
                buf.writeBoolean(this.dataToKeep != 0);
            } else if (version.lessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
                buf.writeByte(this.dataToKeep);
            }
        } else {
            ProtocolUtils.writeString(buf, this.levelType);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            if (this.lastDeathPosition != null) {
                buf.writeBoolean(true);
                ProtocolUtils.writeString(buf, this.lastDeathPosition.key());
                buf.writeLong(this.lastDeathPosition.value());
            } else {
                buf.writeBoolean(false);
            }
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20)) {
            ProtocolUtils.writeVarInt(buf, this.portalCooldown);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_21_2)) {
            ProtocolUtils.writeVarInt(buf, this.seaLevel);
        }
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_20_2)) {
            buf.writeByte(this.dataToKeep);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

