/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import net.kyori.adventure.key.Key;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerboundCookieResponsePacket
implements MinecraftPacket {
    private Key key;
    private byte @Nullable [] payload;

    public Key getKey() {
        return this.key;
    }

    public byte @Nullable [] getPayload() {
        return this.payload;
    }

    public ServerboundCookieResponsePacket() {
    }

    public ServerboundCookieResponsePacket(Key key, byte @Nullable [] payload) {
        this.key = key;
        this.payload = payload;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.key = ProtocolUtils.readKey(buf);
        if (buf.readBoolean()) {
            this.payload = ProtocolUtils.readByteArray(buf, 5120);
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeKey(buf, this.key);
        boolean hasPayload = this.payload != null && this.payload.length > 0;
        buf.writeBoolean(hasPayload);
        if (hasPayload) {
            ProtocolUtils.writeByteArray(buf, this.payload);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

