/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.title;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.protocol.packet.title.GenericTitlePacket;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LegacyTitlePacket
extends GenericTitlePacket {
    private @Nullable ComponentHolder component;
    private int fadeIn;
    private int stay;
    private int fadeOut;

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.lessThan(ProtocolVersion.MINECRAFT_1_11) && this.getAction() == GenericTitlePacket.ActionType.SET_ACTION_BAR) {
            throw new IllegalStateException("Action bars are only supported on 1.11 and newer");
        }
        ProtocolUtils.writeVarInt(buf, this.getAction().getAction(version));
        switch (this.getAction()) {
            case SET_TITLE: 
            case SET_SUBTITLE: 
            case SET_ACTION_BAR: {
                if (this.component == null) {
                    throw new IllegalStateException("No component found for " + this.getAction());
                }
                this.component.write(buf);
                break;
            }
            case SET_TIMES: {
                buf.writeInt(this.fadeIn);
                buf.writeInt(this.stay);
                buf.writeInt(this.fadeOut);
                break;
            }
            case HIDE: 
            case RESET: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown action " + this.getAction());
            }
        }
    }

    @Override
    public void setAction(GenericTitlePacket.ActionType action) {
        super.setAction(action);
    }

    @Override
    public @Nullable ComponentHolder getComponent() {
        return this.component;
    }

    @Override
    public void setComponent(@Nullable ComponentHolder component) {
        this.component = component;
    }

    @Override
    public int getFadeIn() {
        return this.fadeIn;
    }

    @Override
    public void setFadeIn(int fadeIn) {
        this.fadeIn = fadeIn;
    }

    @Override
    public int getStay() {
        return this.stay;
    }

    @Override
    public void setStay(int stay) {
        this.stay = stay;
    }

    @Override
    public int getFadeOut() {
        return this.fadeOut;
    }

    @Override
    public void setFadeOut(int fadeOut) {
        this.fadeOut = fadeOut;
    }

    public String toString() {
        return "GenericTitlePacket{action=" + this.getAction() + ", component='" + this.component + "', fadeIn=" + this.fadeIn + ", stay=" + this.stay + ", fadeOut=" + this.fadeOut + "}";
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

