/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.event;

import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;

class EventTypeTracker {
    private final ConcurrentMap<Class<?>, ImmutableSet<Class<?>>> friends = new ConcurrentHashMap();

    public Collection<Class<?>> getFriendsOf(Class<?> eventType) {
        ImmutableSet existingFriends = (ImmutableSet)this.friends.get(eventType);
        if (existingFriends != null) {
            return existingFriends;
        }
        Collection<Class<?>> types = EventTypeTracker.getEventTypes(eventType);
        for (Class<?> type : types) {
            if (type == eventType) continue;
            this.friends.merge(type, ImmutableSet.of(eventType), (oldVal, newSingleton) -> ((ImmutableSet.Builder)((ImmutableSet.Builder)ImmutableSet.builder().addAll((Iterable)oldVal)).addAll((Iterable)newSingleton)).build());
        }
        return types;
    }

    private static Collection<Class<?>> getEventTypes(Class<?> eventType) {
        return TypeToken.of(eventType).getTypes().rawTypes().stream().filter(type -> type != Object.class).collect(Collectors.toList());
    }
}

