/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.keyed;

import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.packet.chat.RateLimitedCommandHandler;
import com.velocitypowered.proxy.protocol.packet.chat.builder.ChatBuilderV2;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerCommandPacket;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;

public class KeyedCommandHandler
extends RateLimitedCommandHandler<KeyedPlayerCommandPacket> {
    private final ConnectedPlayer player;
    private final VelocityServer server;

    public KeyedCommandHandler(ConnectedPlayer player, VelocityServer server) {
        super(player, server);
        this.player = player;
        this.server = server;
    }

    @Override
    public Class<KeyedPlayerCommandPacket> packetClass() {
        return KeyedPlayerCommandPacket.class;
    }

    @Override
    public void handlePlayerCommandInternal(KeyedPlayerCommandPacket packet) {
        this.queueCommandResult(this.server, this.player, (event, newLastSeenMessages) -> {
            CommandExecuteEvent.CommandResult result = event.getResult();
            IdentifiedKey playerKey = this.player.getIdentifiedKey();
            if (result == CommandExecuteEvent.CommandResult.denied()) {
                if (playerKey != null && !packet.isUnsigned() && playerKey.getKeyRevision().noLessThan(IdentifiedKey.Revision.LINKED_V2)) {
                    logger.fatal("A plugin tried to deny a command with signable component(s). This is not supported. Disconnecting player " + this.player.getUsername() + ". Command packet: " + packet);
                    this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
                }
                return CompletableFuture.completedFuture(null);
            }
            String commandToRun = result.getCommand().orElse(packet.getCommand());
            if (result.isForwardToServer()) {
                ChatBuilderV2 write = this.player.getChatBuilderFactory().builder().setTimestamp(packet.getTimestamp()).asPlayer(this.player);
                if (!packet.isUnsigned() && commandToRun.equals(packet.getCommand())) {
                    return CompletableFuture.completedFuture(packet);
                }
                if (!packet.isUnsigned() && playerKey != null && playerKey.getKeyRevision().noLessThan(IdentifiedKey.Revision.LINKED_V2)) {
                    logger.fatal("A plugin tried to change a command with signed component(s). This is not supported. Disconnecting player " + this.player.getUsername() + ". Command packet: " + packet);
                    this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
                    return CompletableFuture.completedFuture(null);
                }
                write.message("/" + commandToRun);
                return CompletableFuture.completedFuture(write.toServer());
            }
            return this.runCommand(this.server, this.player, commandToRun, hasRun -> {
                if (!hasRun.booleanValue()) {
                    if (commandToRun.equals(packet.getCommand())) {
                        return packet;
                    }
                    if (!packet.isUnsigned() && playerKey != null && playerKey.getKeyRevision().noLessThan(IdentifiedKey.Revision.LINKED_V2)) {
                        logger.fatal("A plugin tried to change a command with signed component(s). This is not supported. Disconnecting player " + this.player.getUsername() + ". Command packet: " + packet);
                        this.player.disconnect(Component.text("A proxy plugin caused an illegal protocol state. Contact your network administrator."));
                        return null;
                    }
                    return this.player.getChatBuilderFactory().builder().setTimestamp(packet.getTimestamp()).asPlayer(this.player).message("/" + commandToRun).toServer();
                }
                return null;
            });
        }, packet.getCommand(), packet.getTimestamp(), null, new CommandExecuteEvent.InvocationInfo(CommandExecuteEvent.SignedState.UNSUPPORTED, CommandExecuteEvent.Source.PLAYER));
    }
}

