/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event;

import com.google.common.base.Preconditions;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ResultedEvent<R extends Result> {
    public R getResult();

    public void setResult(R var1);

    public static final class ComponentResult
    implements Result {
        private static final ComponentResult ALLOWED = new ComponentResult(true, null);
        private final boolean status;
        private final @Nullable Component reason;

        protected ComponentResult(boolean status, @Nullable Component reason) {
            this.status = status;
            this.reason = reason;
        }

        @Override
        public boolean isAllowed() {
            return this.status;
        }

        public Optional<Component> getReasonComponent() {
            return Optional.ofNullable(this.reason);
        }

        public String toString() {
            if (this.status) {
                return "allowed";
            }
            if (this.reason != null) {
                return "denied: " + PlainTextComponentSerializer.plainText().serialize(this.reason);
            }
            return "denied";
        }

        public static ComponentResult allowed() {
            return ALLOWED;
        }

        public static ComponentResult denied(Component reason) {
            Preconditions.checkNotNull(reason, "reason");
            return new ComponentResult(false, reason);
        }
    }

    public static final class GenericResult
    implements Result {
        private static final GenericResult ALLOWED = new GenericResult(true);
        private static final GenericResult DENIED = new GenericResult(false);
        private final boolean status;

        private GenericResult(boolean b) {
            this.status = b;
        }

        @Override
        public boolean isAllowed() {
            return this.status;
        }

        public String toString() {
            return this.status ? "allowed" : "denied";
        }

        public static GenericResult allowed() {
            return ALLOWED;
        }

        public static GenericResult denied() {
            return DENIED;
        }
    }

    public static interface Result {
        public boolean isAllowed();
    }
}

