/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.console;

import com.velocitypowered.api.event.permission.PermissionsSetupEvent;
import com.velocitypowered.api.permission.PermissionFunction;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.proxy.ConsoleCommandSource;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.util.ClosestLocaleMatcher;
import java.util.List;
import java.util.Locale;
import net.kyori.adventure.audience.MessageType;
import net.kyori.adventure.identity.Identity;
import net.kyori.adventure.permission.PermissionChecker;
import net.kyori.adventure.platform.facet.FacetPointers;
import net.kyori.adventure.pointer.Pointers;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.logger.slf4j.ComponentLogger;
import net.minecrell.terminalconsole.SimpleTerminalConsole;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.io.IoBuilder;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jetbrains.annotations.NotNull;
import org.jline.reader.Candidate;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;

public final class VelocityConsole
extends SimpleTerminalConsole
implements ConsoleCommandSource {
    private static final Logger logger = LogManager.getLogger(VelocityConsole.class);
    private static final ComponentLogger componentLogger = ComponentLogger.logger(VelocityConsole.class);
    private final VelocityServer server;
    private PermissionFunction permissionFunction = PermissionFunction.ALWAYS_TRUE;
    @NotNull
    private final Pointers pointers = (Pointers)((Pointers.Builder)ConsoleCommandSource.super.pointers().toBuilder()).withDynamic(PermissionChecker.POINTER, this::getPermissionChecker).withDynamic(Identity.LOCALE, () -> ClosestLocaleMatcher.INSTANCE.lookupClosest(Locale.getDefault())).withStatic(FacetPointers.TYPE, FacetPointers.Type.CONSOLE).build();

    public VelocityConsole(VelocityServer server) {
        this.server = server;
    }

    @Override
    public void sendMessage(@NonNull Identity identity, @NonNull Component message, @NonNull MessageType messageType) {
        componentLogger.info(message);
    }

    @Override
    public @NonNull Tristate getPermissionValue(@NonNull String permission) {
        return this.permissionFunction.getPermissionValue(permission);
    }

    public void setupStreams() {
        System.setOut(IoBuilder.forLogger(logger).setLevel(Level.INFO).buildPrintStream());
        System.setErr(IoBuilder.forLogger(logger).setLevel(Level.ERROR).buildPrintStream());
    }

    public void setupPermissions() {
        PermissionsSetupEvent event = new PermissionsSetupEvent(this, s -> PermissionFunction.ALWAYS_TRUE);
        this.permissionFunction = this.server.getEventManager().fire(event).join().createFunction(this);
        if (this.permissionFunction == null) {
            logger.error("A plugin permission provider {} provided an invalid permission function for the console. This is a bug in the plugin, not in Velocity. Falling back to the default permission function.", (Object)event.getProvider().getClass().getName());
            this.permissionFunction = PermissionFunction.ALWAYS_TRUE;
        }
    }

    @Override
    protected LineReader buildReader(LineReaderBuilder builder) {
        return super.buildReader(builder.appName("Velocity").completer((reader, parsedLine, list) -> {
            try {
                List<String> offers = this.server.getCommandManager().offerSuggestions(this, parsedLine.line()).join();
                for (String offer : offers) {
                    list.add(new Candidate(offer));
                }
            }
            catch (Exception e) {
                logger.error("An error occurred while trying to perform tab completion.", (Throwable)e);
            }
        }));
    }

    @Override
    protected boolean isRunning() {
        return !this.server.isShutdown();
    }

    @Override
    protected void runCommand(String command) {
        try {
            if (!this.server.getCommandManager().executeAsync(this, command).join().booleanValue()) {
                this.sendMessage(Component.translatable("velocity.command.command-does-not-exist", (TextColor)NamedTextColor.RED));
            }
        }
        catch (Exception e) {
            logger.error("An error occurred while running this command.", (Throwable)e);
        }
    }

    @Override
    protected void shutdown() {
        this.server.shutdown(true);
    }

    @Override
    @NotNull
    public Pointers pointers() {
        return this.pointers;
    }
}

