/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.util;

import com.google.common.io.ByteArrayDataOutput;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;

public class ByteBufDataOutput
extends OutputStream
implements ByteArrayDataOutput {
    private final ByteBuf buf;
    private final DataOutputStream utf8out;

    public ByteBufDataOutput(ByteBuf buf) {
        this.buf = buf;
        this.utf8out = new DataOutputStream(this);
    }

    @Override
    public byte[] toByteArray() {
        return ByteBufUtil.getBytes(this.buf);
    }

    @Override
    public void write(int b) {
        this.buf.writeByte(b);
    }

    @Override
    public void write(byte[] b) {
        this.buf.writeBytes(b);
    }

    @Override
    public void write(byte[] b, int off, int len) {
        this.buf.writeBytes(b, off, len);
    }

    @Override
    public void writeBoolean(boolean v) {
        this.buf.writeBoolean(v);
    }

    @Override
    public void writeByte(int v) {
        this.buf.writeByte(v);
    }

    @Override
    public void writeShort(int v) {
        this.buf.writeShort(v);
    }

    @Override
    public void writeChar(int v) {
        this.buf.writeChar(v);
    }

    @Override
    public void writeInt(int v) {
        this.buf.writeInt(v);
    }

    @Override
    public void writeLong(long v) {
        this.buf.writeLong(v);
    }

    @Override
    public void writeFloat(float v) {
        this.buf.writeFloat(v);
    }

    @Override
    public void writeDouble(double v) {
        this.buf.writeDouble(v);
    }

    @Override
    public void writeBytes(String s) {
        this.buf.writeCharSequence(s, StandardCharsets.US_ASCII);
    }

    @Override
    public void writeChars(String s) {
        for (char c : s.toCharArray()) {
            this.buf.writeChar(c);
        }
    }

    @Override
    public void writeUTF(String s) {
        try {
            this.utf8out.writeUTF(s);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
    }
}

