/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.util.collect.Enum2IntMap;
import io.netty.buffer.ByteBuf;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BossBarPacket
implements MinecraftPacket {
    private static final Enum2IntMap<BossBar.Color> COLORS_TO_PROTOCOL = new Enum2IntMap.Builder<BossBar.Color>(BossBar.Color.class).put(BossBar.Color.PINK, 0).put(BossBar.Color.BLUE, 1).put(BossBar.Color.RED, 2).put(BossBar.Color.GREEN, 3).put(BossBar.Color.YELLOW, 4).put(BossBar.Color.PURPLE, 5).put(BossBar.Color.WHITE, 6).build();
    private static final Enum2IntMap<BossBar.Overlay> OVERLAY_TO_PROTOCOL = new Enum2IntMap.Builder<BossBar.Overlay>(BossBar.Overlay.class).put(BossBar.Overlay.PROGRESS, 0).put(BossBar.Overlay.NOTCHED_6, 1).put(BossBar.Overlay.NOTCHED_10, 2).put(BossBar.Overlay.NOTCHED_12, 3).put(BossBar.Overlay.NOTCHED_20, 4).build();
    private static final Enum2IntMap<BossBar.Flag> FLAG_BITS_TO_PROTOCOL = new Enum2IntMap.Builder<BossBar.Flag>(BossBar.Flag.class).put(BossBar.Flag.DARKEN_SCREEN, 1).put(BossBar.Flag.PLAY_BOSS_MUSIC, 2).put(BossBar.Flag.CREATE_WORLD_FOG, 4).build();
    public static final int ADD = 0;
    public static final int REMOVE = 1;
    public static final int UPDATE_PERCENT = 2;
    public static final int UPDATE_NAME = 3;
    public static final int UPDATE_STYLE = 4;
    public static final int UPDATE_PROPERTIES = 5;
    private @Nullable UUID uuid;
    private int action;
    private @Nullable ComponentHolder name;
    private float percent;
    private int color;
    private int overlay;
    private short flags;

    public static BossBarPacket createAddPacket(UUID id, BossBar bar, ComponentHolder name) {
        BossBarPacket packet = new BossBarPacket();
        packet.setUuid(id);
        packet.setAction(0);
        packet.setName(name);
        packet.setColor(COLORS_TO_PROTOCOL.get(bar.color()));
        packet.setOverlay(OVERLAY_TO_PROTOCOL.get(bar.overlay()));
        packet.setPercent(bar.progress());
        packet.setFlags(BossBarPacket.serializeFlags(bar.flags()));
        return packet;
    }

    public static BossBarPacket createRemovePacket(UUID id, BossBar bar) {
        BossBarPacket packet = new BossBarPacket();
        packet.setUuid(id);
        packet.setAction(1);
        return packet;
    }

    public static BossBarPacket createUpdateProgressPacket(UUID id, BossBar bar) {
        BossBarPacket packet = new BossBarPacket();
        packet.setUuid(id);
        packet.setAction(2);
        packet.setPercent(bar.progress());
        return packet;
    }

    public static BossBarPacket createUpdateNamePacket(UUID id, BossBar bar, ComponentHolder name) {
        BossBarPacket packet = new BossBarPacket();
        packet.setUuid(id);
        packet.setAction(3);
        packet.setName(name);
        return packet;
    }

    public static BossBarPacket createUpdateStylePacket(UUID id, BossBar bar) {
        BossBarPacket packet = new BossBarPacket();
        packet.setUuid(id);
        packet.setAction(4);
        packet.setColor(COLORS_TO_PROTOCOL.get(bar.color()));
        packet.setOverlay(OVERLAY_TO_PROTOCOL.get(bar.overlay()));
        return packet;
    }

    public static BossBarPacket createUpdatePropertiesPacket(UUID id, BossBar bar) {
        BossBarPacket packet = new BossBarPacket();
        packet.setUuid(id);
        packet.setAction(5);
        packet.setFlags(BossBarPacket.serializeFlags(bar.flags()));
        return packet;
    }

    public UUID getUuid() {
        if (this.uuid == null) {
            throw new IllegalStateException("No boss bar UUID specified");
        }
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public @Nullable ComponentHolder getName() {
        return this.name;
    }

    public void setName(ComponentHolder name) {
        this.name = name;
    }

    public float getPercent() {
        return this.percent;
    }

    public void setPercent(float percent) {
        this.percent = percent;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public int getOverlay() {
        return this.overlay;
    }

    public void setOverlay(int overlay) {
        this.overlay = overlay;
    }

    public short getFlags() {
        return this.flags;
    }

    public void setFlags(short flags) {
        this.flags = flags;
    }

    public String toString() {
        return "BossBar{uuid=" + String.valueOf(this.uuid) + ", action=" + this.action + ", name='" + String.valueOf(this.name) + "', percent=" + this.percent + ", color=" + this.color + ", overlay=" + this.overlay + ", flags=" + this.flags + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.uuid = ProtocolUtils.readUuid(buf);
        this.action = ProtocolUtils.readVarInt(buf);
        switch (this.action) {
            case 0: {
                this.name = ComponentHolder.read(buf, version);
                this.percent = buf.readFloat();
                this.color = ProtocolUtils.readVarInt(buf);
                this.overlay = ProtocolUtils.readVarInt(buf);
                this.flags = buf.readUnsignedByte();
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.percent = buf.readFloat();
                break;
            }
            case 3: {
                this.name = ComponentHolder.read(buf, version);
                break;
            }
            case 4: {
                this.color = ProtocolUtils.readVarInt(buf);
                this.overlay = ProtocolUtils.readVarInt(buf);
                break;
            }
            case 5: {
                this.flags = buf.readUnsignedByte();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown action " + this.action);
            }
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.uuid == null) {
            throw new IllegalStateException("No boss bar UUID specified");
        }
        ProtocolUtils.writeUuid(buf, this.uuid);
        ProtocolUtils.writeVarInt(buf, this.action);
        switch (this.action) {
            case 0: {
                if (this.name == null) {
                    throw new IllegalStateException("No name specified!");
                }
                this.name.write(buf);
                buf.writeFloat(this.percent);
                ProtocolUtils.writeVarInt(buf, this.color);
                ProtocolUtils.writeVarInt(buf, this.overlay);
                buf.writeByte(this.flags);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                buf.writeFloat(this.percent);
                break;
            }
            case 3: {
                if (this.name == null) {
                    throw new IllegalStateException("No name specified!");
                }
                this.name.write(buf);
                break;
            }
            case 4: {
                ProtocolUtils.writeVarInt(buf, this.color);
                ProtocolUtils.writeVarInt(buf, this.overlay);
                break;
            }
            case 5: {
                buf.writeByte(this.flags);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown action " + this.action);
            }
        }
    }

    private static byte serializeFlags(Set<BossBar.Flag> flags) {
        byte val = 0;
        for (BossBar.Flag flag : flags) {
            val = (byte)(val | FLAG_BITS_TO_PROTOCOL.get(flag));
        }
        return val;
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

