/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.velocitypowered.api.proxy.player.PlayerSettings;
import com.velocitypowered.api.proxy.player.SkinParts;
import com.velocitypowered.proxy.protocol.packet.ClientSettingsPacket;
import java.util.Locale;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClientSettingsWrapper
implements PlayerSettings {
    static final PlayerSettings DEFAULT = new ClientSettingsWrapper(new ClientSettingsPacket("en_us", 2, 0, true, 0, 1, false, false, 0));
    private final ClientSettingsPacket settings;
    private final SkinParts parts;
    private @Nullable Locale locale;

    ClientSettingsWrapper(ClientSettingsPacket settings) {
        this.settings = settings;
        this.parts = new SkinParts((byte)settings.getSkinParts());
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = Locale.forLanguageTag(this.settings.getLocale().replaceAll("_", "-"));
        }
        return this.locale;
    }

    @Override
    public byte getViewDistance() {
        return this.settings.getViewDistance();
    }

    @Override
    public PlayerSettings.ChatMode getChatMode() {
        return switch (this.settings.getChatVisibility()) {
            case 1 -> PlayerSettings.ChatMode.COMMANDS_ONLY;
            case 2 -> PlayerSettings.ChatMode.HIDDEN;
            default -> PlayerSettings.ChatMode.SHOWN;
        };
    }

    @Override
    public boolean hasChatColors() {
        return this.settings.isChatColors();
    }

    @Override
    public SkinParts getSkinParts() {
        return this.parts;
    }

    @Override
    public PlayerSettings.MainHand getMainHand() {
        return this.settings.getMainHand() == 1 ? PlayerSettings.MainHand.RIGHT : PlayerSettings.MainHand.LEFT;
    }

    @Override
    public boolean isClientListingAllowed() {
        return this.settings.isClientListingAllowed();
    }

    @Override
    public boolean isTextFilteringEnabled() {
        return this.settings.isTextFilteringEnabled();
    }

    @Override
    public PlayerSettings.ParticleStatus getParticleStatus() {
        return switch (this.settings.getParticleStatus()) {
            case 1 -> PlayerSettings.ParticleStatus.DECREASED;
            case 2 -> PlayerSettings.ParticleStatus.MINIMAL;
            default -> PlayerSettings.ParticleStatus.ALL;
        };
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClientSettingsWrapper that = (ClientSettingsWrapper)o;
        return Objects.equals(this.settings, that.settings) && Objects.equals(this.parts, that.parts) && Objects.equals(this.locale, that.locale);
    }

    public int hashCode() {
        return Objects.hash(this.settings, this.parts, this.locale);
    }
}

