/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.uring;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.socket.ServerSocketChannel;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.SocketChannelConfig;
import io.netty.channel.unix.Errors;
import io.netty.channel.unix.IovArray;
import io.netty.channel.uring.AbstractIoUringChannel;
import io.netty.channel.uring.AbstractIoUringStreamChannel;
import io.netty.channel.uring.IoUring;
import io.netty.channel.uring.IoUringIoHandler;
import io.netty.channel.uring.IoUringIoOps;
import io.netty.channel.uring.IoUringSocketChannelConfig;
import io.netty.channel.uring.LinuxSocket;
import io.netty.channel.uring.MsgHdrMemory;
import io.netty.channel.uring.MsgHdrMemoryArray;
import io.netty.channel.uring.Native;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayDeque;
import java.util.Queue;

public final class IoUringSocketChannel
extends AbstractIoUringStreamChannel
implements SocketChannel {
    private final IoUringSocketChannelConfig config = new IoUringSocketChannelConfig(this);
    private static final Object ZC_BATCH_MARKER = new Object();

    public IoUringSocketChannel() {
        super(null, LinuxSocket.newSocketStream(), false);
    }

    IoUringSocketChannel(Channel parent, LinuxSocket fd) {
        super(parent, fd, true);
    }

    IoUringSocketChannel(Channel parent, LinuxSocket fd, SocketAddress remote) {
        super(parent, fd, remote);
    }

    @Override
    public ServerSocketChannel parent() {
        return (ServerSocketChannel)super.parent();
    }

    @Override
    public SocketChannelConfig config() {
        return this.config;
    }

    @Override
    public InetSocketAddress remoteAddress() {
        return (InetSocketAddress)super.remoteAddress();
    }

    @Override
    public InetSocketAddress localAddress() {
        return (InetSocketAddress)super.localAddress();
    }

    @Override
    protected AbstractIoUringChannel.AbstractUringUnsafe newUnsafe() {
        return new IoUringSocketUnsafe();
    }

    private final class IoUringSocketUnsafe
    extends AbstractIoUringStreamChannel.IoUringStreamUnsafe {
        private Queue<Object> zcWriteQueue;

        private IoUringSocketUnsafe() {
        }

        @Override
        protected int scheduleWriteSingle(Object msg) {
            assert (IoUringSocketChannel.this.writeId == 0L);
            if (IoUring.isSendZcSupported() && msg instanceof ByteBuf) {
                ByteBuf buf = (ByteBuf)msg;
                int length = buf.readableBytes();
                if (((IoUringSocketChannelConfig)IoUringSocketChannel.this.config()).shouldWriteZeroCopy(length)) {
                    long address = IoUring.memoryAddress(buf) + (long)buf.readerIndex();
                    IoUringIoOps ops = IoUringIoOps.newSendZc(IoUringSocketChannel.this.fd().intValue(), address, length, 0, IoUringSocketChannel.this.nextOpsId(), 0);
                    byte opCode = ops.opcode();
                    IoUringSocketChannel.this.writeId = IoUringSocketChannel.this.registration().submit(ops);
                    IoUringSocketChannel.this.writeOpCode = opCode;
                    if (IoUringSocketChannel.this.writeId == 0L) {
                        return 0;
                    }
                    return 1;
                }
            }
            return super.scheduleWriteSingle(msg);
        }

        @Override
        protected int scheduleWriteMultiple(ChannelOutboundBuffer in) {
            assert (IoUringSocketChannel.this.writeId == 0L);
            if (IoUring.isSendmsgZcSupported() && ((IoUringSocketChannelConfig)IoUringSocketChannel.this.config()).shouldWriteZeroCopy((int)in.totalPendingWriteBytes())) {
                IoUringIoHandler handler = (IoUringIoHandler)IoUringSocketChannel.this.registration().attachment();
                IovArray iovArray = handler.iovArray();
                int offset = iovArray.count();
                iovArray.maxCount(Native.MAX_SKB_FRAGS);
                try {
                    in.forEachFlushedMessage(iovArray);
                }
                catch (Exception e) {
                    return this.scheduleWriteSingle(in.current());
                }
                long iovArrayAddress = iovArray.memoryAddress(offset);
                int iovArrayLength = iovArray.count() - offset;
                MsgHdrMemoryArray msgHdrArray = handler.msgHdrMemoryArray();
                MsgHdrMemory hdr = msgHdrArray.nextHdr();
                assert (hdr != null);
                hdr.set(iovArrayAddress, iovArrayLength);
                IoUringIoOps ops = IoUringIoOps.newSendmsgZc(IoUringSocketChannel.this.fd().intValue(), (byte)0, 0, hdr.address(), IoUringSocketChannel.this.nextOpsId());
                byte opCode = ops.opcode();
                IoUringSocketChannel.this.writeId = IoUringSocketChannel.this.registration().submit(ops);
                IoUringSocketChannel.this.writeOpCode = opCode;
                if (IoUringSocketChannel.this.writeId == 0L) {
                    return 0;
                }
                return 1;
            }
            return super.scheduleWriteMultiple(in);
        }

        @Override
        boolean writeComplete0(byte op, int res, int flags, short data, int outstanding) {
            ChannelOutboundBuffer channelOutboundBuffer = IoUringSocketChannel.this.unsafe().outboundBuffer();
            if (op == 47 || op == 48) {
                return this.handleWriteCompleteZeroCopy(op, channelOutboundBuffer, res, flags);
            }
            return super.writeComplete0(op, res, flags, data, outstanding);
        }

        private boolean handleWriteCompleteZeroCopy(byte op, ChannelOutboundBuffer channelOutboundBuffer, int res, int flags) {
            if (res == Native.ERRNO_ECANCELED_NEGATIVE) {
                return true;
            }
            if ((flags & 8) == 0) {
                boolean more;
                IoUringSocketChannel.this.writeId = 0L;
                IoUringSocketChannel.this.writeOpCode = 0;
                boolean bl = more = (flags & 2) != 0;
                if (res >= 0) {
                    if (more) {
                        int readable;
                        if (this.zcWriteQueue == null) {
                            this.zcWriteQueue = new ArrayDeque<Object>(8);
                        }
                        do {
                            ByteBuf currentBuffer = (ByteBuf)channelOutboundBuffer.current();
                            assert (currentBuffer != null);
                            this.zcWriteQueue.add(currentBuffer);
                            currentBuffer.retain();
                            readable = currentBuffer.readableBytes();
                            int skip = Math.min(readable, res);
                            currentBuffer.skipBytes(skip);
                            channelOutboundBuffer.progress(readable);
                            if (readable > res) continue;
                            boolean removed = channelOutboundBuffer.remove();
                            assert (removed);
                        } while ((res -= readable) > 0);
                        this.zcWriteQueue.add(ZC_BATCH_MARKER);
                    } else {
                        channelOutboundBuffer.removeBytes(res);
                    }
                    return true;
                }
                try {
                    String msg;
                    String string = msg = op == 47 ? "io_uring sendzc" : "io_uring sendmsg_zc";
                    if (Errors.ioResult(msg, res) == 0) {
                        return false;
                    }
                }
                catch (Throwable cause) {
                    this.handleWriteError(cause);
                }
            } else if (this.zcWriteQueue != null) {
                while (true) {
                    Object queued = this.zcWriteQueue.remove();
                    assert (queued != null);
                    if (queued == ZC_BATCH_MARKER) break;
                    ((ByteBuf)queued).release();
                }
            }
            return true;
        }

        @Override
        protected boolean canCloseNow0() {
            return (this.zcWriteQueue == null || this.zcWriteQueue.isEmpty()) && super.canCloseNow0();
        }
    }
}

