/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.plugin.util;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.graph.Graph;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.plugin.meta.PluginDependency;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class PluginDependencyUtils {
    private PluginDependencyUtils() {
        throw new AssertionError();
    }

    public static List<PluginDescription> sortCandidates(List<PluginDescription> candidates) {
        ArrayList<PluginDescription> sortedCandidates = new ArrayList<PluginDescription>(candidates);
        sortedCandidates.sort(Comparator.comparing(PluginDescription::getId));
        MutableGraph<PluginDescription> graph = GraphBuilder.directed().allowsSelfLoops(false).expectedNodeCount(sortedCandidates.size()).build();
        ImmutableMap candidateMap = Maps.uniqueIndex(sortedCandidates, PluginDescription::getId);
        for (PluginDescription description : sortedCandidates) {
            graph.addNode(description);
            for (PluginDependency dependency : description.getDependencies()) {
                PluginDescription in = (PluginDescription)candidateMap.get(dependency.getId());
                if (in == null) continue;
                graph.putEdge(description, in);
            }
        }
        ArrayList<PluginDescription> sorted = new ArrayList<PluginDescription>();
        HashMap<PluginDescription, Mark> marks = new HashMap<PluginDescription, Mark>();
        for (PluginDescription node : graph.nodes()) {
            PluginDependencyUtils.visitNode(graph, node, marks, sorted, new ArrayDeque<PluginDescription>());
        }
        return sorted;
    }

    private static void visitNode(Graph<PluginDescription> dependencyGraph, PluginDescription current, Map<PluginDescription, Mark> visited, List<PluginDescription> sorted, Deque<PluginDescription> currentDependencyScanStack) {
        Mark mark = visited.getOrDefault(current, Mark.NOT_VISITED);
        if (mark == Mark.VISITED) {
            return;
        }
        if (mark == Mark.VISITING) {
            currentDependencyScanStack.addLast(current);
            String loop = currentDependencyScanStack.stream().map(PluginDescription::getId).collect(Collectors.joining(" -> "));
            throw new IllegalStateException("Circular dependency detected: " + loop);
        }
        currentDependencyScanStack.addLast(current);
        visited.put(current, Mark.VISITING);
        for (PluginDescription edge : dependencyGraph.successors((Object)current)) {
            PluginDependencyUtils.visitNode(dependencyGraph, edge, visited, sorted, currentDependencyScanStack);
        }
        visited.put(current, Mark.VISITED);
        currentDependencyScanStack.removeLast();
        sorted.add(current);
    }

    private static enum Mark {
        NOT_VISITED,
        VISITING,
        VISITED;

    }
}

